/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import org.freeplane.api.ConditionalStyleNotFoundException;
import org.freeplane.features.filter.condition.ASelectableCondition;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.styles.ConditionalStyleModel;
import org.freeplane.features.styles.IStyle;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.MLogicalStyleController;
import org.freeplane.plugin.script.filter.ScriptCondition;
import org.freeplane.plugin.script.proxy.AConditionalStyleProxy;
import org.freeplane.plugin.script.proxy.NodeStyleProxy;

public class NodeConditionalStyleProxy
extends AConditionalStyleProxy<NodeModel> {
    public NodeConditionalStyleProxy(NodeModel nodeModel, ConditionalStyleModel.Item item) {
        super(nodeModel, item);
    }

    public NodeConditionalStyleProxy(NodeModel nodeModel, boolean isActive, String script, String styleName, boolean isLast) {
        super(nodeModel, isActive, script, styleName, isLast);
    }

    public NodeConditionalStyleProxy(NodeModel nodeModel, boolean isActive, ASelectableCondition condition, IStyle style, boolean isLast) {
        super(nodeModel, isActive, condition, style, isLast);
    }

    @Override
    ConditionalStyleModel getConditionalStyleModel() {
        return ConditionalStyleModel.createConditionalStyleModel((NodeModel)((NodeModel)this.getDelegate()));
    }

    public void setActive(boolean isActive) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.setActiveForConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), this.getIndex(), isActive);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public void setScript(String script) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        ScriptCondition condition = script == null ? null : new ScriptCondition(script);
        controller.setConditionForConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), this.getIndex(), (ASelectableCondition)condition);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public void setStyleName(String styleName) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        IStyle style = NodeStyleProxy.styleByNameOrThrowException(((NodeModel)this.getDelegate()).getMap(), styleName);
        controller.setStyleForConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), this.getIndex(), style);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public void setLast(boolean isLast) {
        MLogicalStyleController controller = (MLogicalStyleController)LogicalStyleController.getController();
        controller.setLastForConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), this.getIndex(), isLast);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public void moveTo(int toIndex) {
        int index = this.getIndex();
        if (index == -1) {
            throw new ConditionalStyleNotFoundException(this.toString());
        }
        if (toIndex == index) {
            return;
        }
        MLogicalStyleController.getController().moveConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), index, toIndex);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
    }

    public NodeConditionalStyleProxy remove() {
        int index = this.getIndex();
        if (index == -1) {
            throw new ConditionalStyleNotFoundException(this.toString());
        }
        ConditionalStyleModel.Item item = MLogicalStyleController.getController().removeConditionalStyle(((NodeModel)this.getDelegate()).getMap(), this.getConditionalStyleModel(), index);
        this.callDelayedRefresh((NodeModel)this.getDelegate());
        return new NodeConditionalStyleProxy((NodeModel)this.getDelegate(), item);
    }

    private void callDelayedRefresh(NodeModel nodeModel) {
        Controller.getCurrentModeController().getMapController().refreshNodeLaterUndoable(nodeModel, NodeModel.UNKNOWN_PROPERTY, null, null);
    }
}

