/*
 * Decompiled with CFR 0.152.
 */
package ghidra.feature.fid.service;

import generic.cache.Factory;
import ghidra.feature.fid.hash.FidHashQuad;
import ghidra.program.model.address.Address;
import ghidra.program.model.listing.Function;
import ghidra.util.datastruct.LRUMap;

public class FIDFixedSizeMRUCachingFactory
implements Factory<Function, FidHashQuad> {
    private LRUMap<Address, FidHashQuad> cache;
    private Factory<Function, FidHashQuad> delegate;

    public FIDFixedSizeMRUCachingFactory(Factory<Function, FidHashQuad> factory, int size) {
        this.delegate = factory;
        this.cache = new LRUMap(size);
    }

    public FidHashQuad get(Function func) {
        Address entryPoint = func.getEntryPoint();
        FidHashQuad value = (FidHashQuad)this.cache.get((Object)entryPoint);
        if (value != null) {
            return value;
        }
        value = (FidHashQuad)this.delegate.get((Object)func);
        if (value == null) {
            return null;
        }
        this.cache.put((Object)entryPoint, (Object)value);
        return value;
    }
}

