/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.archive;

import generic.io.JarWriter;
import ghidra.framework.model.Project;
import ghidra.util.Msg;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

class ArchiveTask
extends Task {
    private File jarFile;
    private Project project;
    private String projectName;

    ArchiveTask(Project project, File outJarFile) {
        super("Archiving Project: " + project.getName(), true, false, true);
        this.project = project;
        this.jarFile = outJarFile;
        this.projectName = project.getName();
    }

    public void run(TaskMonitor monitor) {
        boolean ok = false;
        try {
            monitor.setMessage("Begin archiving...");
            ok = this.writeProject(monitor);
        }
        catch (Exception e) {
            Msg.showError((Object)((Object)this), null, null, null, (Throwable)e);
        }
        String message = "Archiving \"" + this.project.getName() + "\" to \"" + this.jarFile.getAbsolutePath() + "\"";
        message = monitor.isCancelled() ? message + " was cancelled by user." : message + (ok ? " succeeded." : " failed.");
        Msg.info((Object)((Object)this), (Object)message);
        if (!ok && this.jarFile.exists() && !this.jarFile.delete()) {
            Msg.error((Object)((Object)this), (Object)("Couldn't remove bad jar file (" + this.jarFile.getAbsolutePath() + ")"));
        }
    }

    private boolean writeProject(TaskMonitor monitor) throws IOException {
        boolean ok = false;
        JarOutputStream jarOut = new JarOutputStream(new FileOutputStream(this.jarFile));
        JarWriter writer = new JarWriter(jarOut, new String[]{".ulock"});
        String archiveComment = "Ghidra archive file for " + this.projectName + " project.";
        jarOut.setComment(archiveComment);
        File projectFile = this.project.getProjectLocator().getMarkerFile();
        ok = writer.outputFile(projectFile, "", monitor);
        if (ok) {
            ZipEntry entry = new ZipEntry("JAR_FORMAT");
            jarOut.putNextEntry(entry);
            ok = this.writeProjectDirs(writer, monitor);
        }
        jarOut.close();
        return ok;
    }

    private boolean writeProjectDirs(JarWriter writer, TaskMonitor monitor) {
        File projectFolder = this.project.getProjectLocator().getProjectDir();
        String[] names = projectFolder.list();
        for (int i = 0; i < names.length; ++i) {
            if (monitor.isCancelled()) {
                return false;
            }
            File file = new File(projectFolder, names[i]);
            monitor.setMessage("Writing " + file.getAbsolutePath());
            if (!file.isDirectory() || writer.outputRecursively(file, "", monitor)) continue;
            return false;
        }
        return true;
    }
}

