/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.instructionsearch.ui;

import generic.theme.GThemeDefaults;
import ghidra.app.plugin.core.instructionsearch.InstructionSearchPlugin;
import ghidra.app.plugin.core.instructionsearch.model.InstructionMetadata;
import ghidra.app.plugin.core.instructionsearch.ui.InstructionSearchDialog;
import ghidra.app.plugin.core.instructionsearch.ui.SearchDirectionWidget;
import ghidra.app.services.GoToService;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.listing.CodeUnit;
import ghidra.program.model.listing.Listing;
import ghidra.program.model.listing.Program;
import ghidra.program.util.BytesFieldLocation;
import ghidra.program.util.ProgramLocation;
import ghidra.util.Swing;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Color;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;

class SearchInstructionsTask
extends Task {
    private InstructionSearchDialog searchDialog;
    private InstructionSearchPlugin searchPlugin;

    SearchInstructionsTask(InstructionSearchDialog dialog, InstructionSearchPlugin plugin) {
        super("Searching Program Text", true, true, false);
        this.searchDialog = dialog;
        this.searchPlugin = plugin;
    }

    public void run(TaskMonitor taskMonitor) {
        if (taskMonitor == null) {
            return;
        }
        List<AddressRange> searchRanges = this.searchDialog.getControlPanel().getRangeWidget().getSearchRange();
        Address currentAddr = this.searchPlugin.getProgramLocation().getByteAddress();
        boolean forward = this.searchDialog.getControlPanel().getDirectionWidget().getSearchDirection().equals((Object)SearchDirectionWidget.Direction.FORWARD);
        if (!forward) {
            Collections.reverse(searchRanges);
        }
        int rangeNum = 0;
        for (AddressRange range : searchRanges) {
            InstructionMetadata searchResults;
            ++rangeNum;
            if (!forward ? currentAddr.compareTo((Object)range.getMinAddress()) <= 0 : currentAddr.compareTo((Object)range.getMaxAddress()) >= 0) continue;
            if (searchRanges.size() > 1) {
                taskMonitor.setMessage("Searching range " + rangeNum + " of " + searchRanges.size());
            } else {
                taskMonitor.setMessage("Searching...");
            }
            if ((searchResults = this.searchDialog.getSearchData().search(this.searchPlugin, range, taskMonitor, forward)) == null) continue;
            Swing.runLater(() -> {
                this.goToLocation(searchResults.getAddr());
                this.searchDialog.getMessagePanel().clear();
            });
            return;
        }
        this.searchDialog.getMessagePanel().setMessageText("No results found", (Color)GThemeDefaults.Colors.Messages.NORMAL);
    }

    public Address getNextAddress(SearchDirectionWidget.Direction direction, List<InstructionMetadata> searchResults) {
        CodeUnit cu;
        Address currentAddress = this.searchPlugin.getProgramLocation().getByteAddress();
        Program currentProgram = this.searchPlugin.getCurrentProgram();
        Listing listing = currentProgram.getListing();
        if (direction == SearchDirectionWidget.Direction.FORWARD) {
            for (InstructionMetadata instr : searchResults) {
                cu = listing.getCodeUnitContaining(instr.getAddr());
                if (cu.getMinAddress().compareTo((Object)currentAddress) <= 0) continue;
                return cu.getMinAddress();
            }
        }
        if (direction == SearchDirectionWidget.Direction.BACKWARD) {
            ListIterator<InstructionMetadata> it = searchResults.listIterator(searchResults.size());
            while (it.hasPrevious()) {
                InstructionMetadata instr;
                instr = it.previous();
                cu = listing.getCodeUnitContaining(instr.getAddr());
                if (cu.getMinAddress().compareTo((Object)currentAddress) >= 0) continue;
                return cu.getMinAddress();
            }
        }
        return null;
    }

    private void goToLocation(Address addr) {
        GoToService gs = (GoToService)this.searchPlugin.getTool().getService(GoToService.class);
        BytesFieldLocation bloc = new BytesFieldLocation(this.searchPlugin.getCurrentProgram(), addr);
        gs.goTo((ProgramLocation)bloc);
    }
}

