/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.dwarf;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.dwarf.DIEAggregate;
import ghidra.app.util.bin.format.dwarf.DWARFAbbreviation;
import ghidra.app.util.bin.format.dwarf.DWARFException;
import ghidra.app.util.bin.format.dwarf.DWARFProgram;
import ghidra.app.util.bin.format.dwarf.DWARFRange;
import ghidra.app.util.bin.format.dwarf.DWARFUnitHeader;
import ghidra.app.util.bin.format.dwarf.DebugInfoEntry;
import ghidra.app.util.bin.format.dwarf.attribs.DWARFAttribute;
import ghidra.app.util.bin.format.dwarf.line.DWARFLine;
import ghidra.util.exception.CancelledException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class DWARFCompilationUnit
extends DWARFUnitHeader {
    private final byte pointerSize;
    private final long firstDIEOffset;
    private final Map<Integer, DWARFAbbreviation> codeToAbbreviationMap;
    protected DIEAggregate diea;
    private DWARFLine line;

    public static DWARFCompilationUnit readV4(DWARFUnitHeader partial, BinaryReader reader, BinaryReader abbrReader, TaskMonitor monitor) throws DWARFException, IOException, CancelledException {
        long abbreviationOffset = reader.readNextUnsignedValue(partial.getIntSize());
        byte pointerSize = reader.readNextByte();
        long firstDIEOffset = reader.getPointerIndex();
        if (firstDIEOffset > partial.endOffset) {
            throw new IOException("Invalid length %d for DWARF Compilation Unit at 0x%x".formatted(partial.endOffset - partial.startOffset, partial.startOffset));
        }
        if (firstDIEOffset == partial.endOffset) {
            return null;
        }
        abbrReader.setPointerIndex(abbreviationOffset);
        Map<Integer, DWARFAbbreviation> abbrMap = DWARFAbbreviation.readAbbreviations(abbrReader, partial.dprog, monitor);
        DWARFCompilationUnit cu = new DWARFCompilationUnit(partial, pointerSize, firstDIEOffset, abbrMap);
        return cu;
    }

    public static DWARFCompilationUnit readV5(DWARFUnitHeader partial, BinaryReader reader, BinaryReader abbrReader, TaskMonitor monitor) throws DWARFException, IOException, CancelledException {
        byte pointerSize = reader.readNextByte();
        long abbreviationOffset = reader.readNextUnsignedValue(partial.getIntSize());
        long firstDIEOffset = reader.getPointerIndex();
        if (firstDIEOffset > partial.endOffset) {
            throw new IOException("Invalid length %d for DWARF Compilation Unit at 0x%x".formatted(partial.endOffset - partial.startOffset, partial.startOffset));
        }
        if (firstDIEOffset == partial.endOffset) {
            return null;
        }
        abbrReader.setPointerIndex(abbreviationOffset);
        Map<Integer, DWARFAbbreviation> abbrMap = DWARFAbbreviation.readAbbreviations(abbrReader, partial.dprog, monitor);
        DWARFCompilationUnit cu = new DWARFCompilationUnit(partial, pointerSize, firstDIEOffset, abbrMap);
        return cu;
    }

    private DWARFCompilationUnit(DWARFUnitHeader partial, byte pointerSize, long firstDIEOffset, Map<Integer, DWARFAbbreviation> abbrMap) {
        super(partial);
        this.pointerSize = pointerSize;
        this.firstDIEOffset = firstDIEOffset;
        this.codeToAbbreviationMap = abbrMap != null ? abbrMap : new HashMap();
    }

    public DWARFCompilationUnit(DWARFProgram dwarfProgram, long startOffset, long endOffset, int intSize, short dwarfVersion, byte pointerSize, int unitNumber, long firstDIEOffset, Map<Integer, DWARFAbbreviation> codeToAbbreviationMap) {
        super(dwarfProgram, startOffset, endOffset, intSize, dwarfVersion, unitNumber);
        this.pointerSize = pointerSize;
        this.firstDIEOffset = firstDIEOffset;
        this.codeToAbbreviationMap = codeToAbbreviationMap != null ? codeToAbbreviationMap : new HashMap();
    }

    public void init(DebugInfoEntry rootDIE) throws IOException {
        this.diea = DIEAggregate.createSingle(rootDIE);
        this.line = this.getProgram().getLine(this.diea, DWARFAttribute.DW_AT_stmt_list);
    }

    public DIEAggregate getCompUnitDIEA() {
        return this.diea;
    }

    public byte getPointerSize() {
        return this.pointerSize;
    }

    public Map<Integer, DWARFAbbreviation> getCodeToAbbreviationMap() {
        return this.codeToAbbreviationMap;
    }

    public DWARFAbbreviation getAbbreviation(int ac) {
        return this.codeToAbbreviationMap.get(ac);
    }

    public long getFirstDIEOffset() {
        return this.firstDIEOffset;
    }

    public DWARFLine getLine() {
        return this.line;
    }

    public String getName() {
        return this.diea.getString(DWARFAttribute.DW_AT_name, null);
    }

    public String getProducer() {
        return this.diea.getString(DWARFAttribute.DW_AT_producer, null);
    }

    public String getCompileDirectory() {
        return this.diea.getString(DWARFAttribute.DW_AT_comp_dir, null);
    }

    public int getLanguage() {
        return (int)this.diea.getUnsignedLong(DWARFAttribute.DW_AT_language, -1L);
    }

    public boolean hasDWO() {
        return this.diea.hasAttribute(DWARFAttribute.DW_AT_GNU_dwo_id) && this.diea.hasAttribute(DWARFAttribute.DW_AT_GNU_dwo_name);
    }

    public long getAddrTableBase() {
        return this.diea.getUnsignedLong(DWARFAttribute.DW_AT_addr_base, 0L);
    }

    public long getRangeListsBase() {
        return this.diea.getUnsignedLong(DWARFAttribute.DW_AT_rnglists_base, 0L);
    }

    public long getLocListsBase() {
        return this.diea.getUnsignedLong(DWARFAttribute.DW_AT_loclists_base, 0L);
    }

    public long getStrOffsetsBase() {
        return this.diea.getUnsignedLong(DWARFAttribute.DW_AT_str_offsets_base, 0L);
    }

    public DWARFRange getPCRange() {
        return this.diea.getPCRange();
    }

    public String toString() {
        return "DWARFCompilationUnit @%x, ver %d, pointersize: %d\n".formatted(this.startOffset, this.dwarfVersion, this.pointerSize) + this.diea.toString().indent(4);
    }
}

