/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.html;

import ghidra.util.html.PreservingWhitespaceHandler;
import ghidra.util.html.TrimmingWhitespaceHandler;
import ghidra.util.html.WhitespaceHandler;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;

public class HtmlLineSplitter {
    public static final int MAX_WORD_LENGTH = 10;

    public static List<String> split(String text, int maxLineLength) {
        return HtmlLineSplitter.split(text, maxLineLength, false);
    }

    public static List<String> split(String text, int maxLineLength, boolean retainSpacing) {
        ArrayList<String> lines = new ArrayList<String>();
        int limit = -1;
        String[] newlines = text.split("\n", limit);
        if (maxLineLength <= 0) {
            lines.addAll(Arrays.asList(newlines));
            return lines;
        }
        WhitespaceHandler counter = retainSpacing ? new PreservingWhitespaceHandler() : new TrimmingWhitespaceHandler();
        for (String line : newlines) {
            if (line.length() == 0) {
                lines.add(line);
                continue;
            }
            List<String> subLines = HtmlLineSplitter.wrap(line, maxLineLength, counter);
            lines.addAll(subLines);
        }
        return lines;
    }

    private static List<String> wrap(String text, int maxLineLength, WhitespaceHandler whitespacer) {
        ArrayList<String> lines = new ArrayList<String>();
        int start = 0;
        int size = 0;
        boolean breakNeeded = false;
        boolean hasForcedBreak = false;
        int length = text.length();
        for (int i = 0; i < length; ++i) {
            String line;
            char c = text.charAt(i);
            boolean hitMaxLength = (size += c == '\t' ? 4 : 1) >= maxLineLength;
            boolean isWhitespace = Character.isWhitespace(c);
            if (breakNeeded) {
                if (isWhitespace) {
                    line = text.substring(start, i);
                    lines.add(line);
                    i += whitespacer.countSpaces(text, i);
                    start = i;
                    size = 0;
                    breakNeeded = false;
                    continue;
                }
                if (size - maxLineLength < 10) continue;
                hasForcedBreak = true;
                breakNeeded = false;
                int end = start + maxLineLength;
                lines.add(text.substring(start, end));
                start = end;
                size = i - start;
                continue;
            }
            if (!hitMaxLength) continue;
            breakNeeded = false;
            line = text.substring(start, i);
            if (!isWhitespace) {
                int end = StringUtils.lastIndexOfAny((CharSequence)line, (CharSequence[])new CharSequence[]{" ", "\t"});
                if (end < 0) {
                    breakNeeded = true;
                    continue;
                }
                line = line.substring(0, end + 1);
            }
            lines.add(whitespacer.trim(line));
            start += line.length();
            start += whitespacer.countSpaces(text, start);
            i = Math.max(i, start);
            size = i - start;
        }
        String line = whitespacer.trim(text.substring(start, length));
        int splitOn = hasForcedBreak ? maxLineLength : -1;
        List<String> remainder = HtmlLineSplitter.forceSplitOn(line, splitOn);
        lines.addAll(remainder);
        return lines;
    }

    private static List<String> forceSplitOn(String s, int size) {
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            buffy.append(s.charAt(i));
            if (buffy.length() != size) continue;
            lines.add(buffy.toString());
            buffy.delete(0, buffy.length());
        }
        if (buffy.length() > 0) {
            lines.add(buffy.toString());
        }
        return lines;
    }
}

