/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import ghidra.docking.settings.Settings;
import ghidra.program.model.data.ArrayDataType;
import ghidra.program.model.data.BitmapResource;
import ghidra.program.model.data.BitmapResourceDataType;
import ghidra.program.model.data.ByteDataType;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataImage;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeComponent;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.IconResource;
import ghidra.program.model.mem.MemBuffer;
import ghidra.util.classfinder.ClassTranslator;
import java.io.IOException;
import java.util.List;

public class IconResourceDataType
extends BitmapResourceDataType {
    private static final long serialVersionUID = 1L;

    public IconResourceDataType() {
        this(null, "IconResource", null);
    }

    public IconResourceDataType(DataTypeManager dtm) {
        this(null, "IconResource", dtm);
    }

    protected IconResourceDataType(CategoryPath path, String name, DataTypeManager dtm) {
        super(path, name, dtm);
    }

    @Override
    public String getDescription() {
        return "Icon stored as a Resource";
    }

    @Override
    public Object getValue(MemBuffer buf, Settings settings, int length) {
        try {
            IconResource icon = new IconResource(buf);
            DataImage img = icon.getDataImage(buf);
            if (img != null) {
                img.setDescription("<Icon-Image>");
            }
            return img;
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    protected BitmapResource getBitmapResource(MemBuffer buf) {
        try {
            return new IconResource(buf);
        }
        catch (IOException ioe) {
            return null;
        }
    }

    @Override
    protected int addComponents(MemBuffer buf, BitmapResource bmr, List<DataTypeComponent> comps) {
        int offset = super.addComponents(buf, bmr, comps);
        int arraySize = bmr.getMaskLength();
        if (arraySize > 0) {
            ArrayDataType array = new ArrayDataType(new ByteDataType(), arraySize, 1);
            offset = this.addComp(array, arraySize, "BitMask", comps, offset);
        }
        return offset;
    }

    @Override
    public String getMnemonic(Settings settings) {
        return "IconRes";
    }

    @Override
    public String getRepresentation(MemBuffer buf, Settings settings, int length) {
        return "<Icon-Image>";
    }

    @Override
    public DataType clone(DataTypeManager dtm) {
        if (dtm == this.getDataTypeManager()) {
            return this;
        }
        return new IconResourceDataType(dtm);
    }

    static {
        ClassTranslator.put((String)"ghidra.app.plugin.prototype.data.IconResourceDataType", (String)IconResourceDataType.class.getName());
    }
}

