/*
 * Decompiled with CFR 0.152.
 */
package ghidra.trace.database.breakpoint;

import db.DBHandle;
import ghidra.framework.data.OpenMode;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSpace;
import ghidra.program.model.lang.Language;
import ghidra.trace.database.DBTrace;
import ghidra.trace.database.breakpoint.DBTraceBreakpointSpace;
import ghidra.trace.database.space.AbstractDBTraceSpaceBasedManager;
import ghidra.trace.database.space.DBTraceDelegatingManager;
import ghidra.trace.database.thread.DBTraceThreadManager;
import ghidra.trace.model.Lifespan;
import ghidra.trace.model.breakpoint.TraceBreakpoint;
import ghidra.trace.model.breakpoint.TraceBreakpointKind;
import ghidra.trace.model.breakpoint.TraceBreakpointManager;
import ghidra.trace.model.breakpoint.TraceObjectBreakpointLocation;
import ghidra.trace.model.thread.TraceThread;
import ghidra.util.LockHold;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.VersionException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

public class DBTraceBreakpointManager
extends AbstractDBTraceSpaceBasedManager<DBTraceBreakpointSpace>
implements TraceBreakpointManager,
DBTraceDelegatingManager<DBTraceBreakpointSpace> {
    protected static final String NAME = "Breakpoint";

    public DBTraceBreakpointManager(DBHandle dbh, OpenMode openMode, ReadWriteLock lock, TaskMonitor monitor, Language baseLanguage, DBTrace trace, DBTraceThreadManager threadManager) throws VersionException, IOException {
        super(NAME, dbh, openMode, lock, monitor, baseLanguage, trace, threadManager);
        this.loadSpaces();
    }

    @Override
    protected DBTraceBreakpointSpace createSpace(AddressSpace space, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        return new DBTraceBreakpointSpace(this, this.dbh, space, ent);
    }

    @Override
    protected DBTraceBreakpointSpace createRegisterSpace(AddressSpace space, TraceThread thread, AbstractDBTraceSpaceBasedManager.DBTraceSpaceEntry ent) throws VersionException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public DBTraceBreakpointSpace getForSpace(AddressSpace space, boolean createIfAbsent) {
        return (DBTraceBreakpointSpace)super.getForSpace(space, createIfAbsent);
    }

    @Override
    public Lock readLock() {
        return this.lock.readLock();
    }

    @Override
    public Lock writeLock() {
        return this.lock.writeLock();
    }

    protected void checkDuplicatePath(TraceBreakpoint ignore, String path, Lifespan lifespan) throws DuplicateNameException {
        for (TraceBreakpoint traceBreakpoint : this.getBreakpointsByPath(path)) {
            if (traceBreakpoint == ignore || !traceBreakpoint.isAlive(lifespan)) continue;
            throw new DuplicateNameException("A breakpoint having path '" + path + "' already exists within an overlapping snap");
        }
    }

    @Override
    public TraceBreakpoint addBreakpoint(String path, Lifespan lifespan, AddressRange range, Collection<TraceThread> threads, Collection<TraceBreakpointKind> kinds, boolean enabled, String comment) throws DuplicateNameException {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().addBreakpoint(path, lifespan, range, threads, kinds, enabled, comment);
        }
        this.checkDuplicatePath(null, path, lifespan);
        return (TraceBreakpoint)this.delegateWrite(range.getAddressSpace(), m -> m.addBreakpoint(path, lifespan, range, threads, kinds, enabled, comment));
    }

    @Override
    public Collection<? extends TraceBreakpoint> getAllBreakpoints() {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getAllObjects(TraceObjectBreakpointLocation.class);
        }
        return this.delegateCollection(this.getActiveMemorySpaces(), m -> m.getAllBreakpoints());
    }

    @Override
    public Collection<? extends TraceBreakpoint> getBreakpointsByPath(String path) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsByPath(path, TraceObjectBreakpointLocation.class);
        }
        return this.delegateCollection(this.getActiveMemorySpaces(), m -> m.getBreakpointsByPath(path));
    }

    @Override
    public TraceBreakpoint getPlacedBreakpointByPath(long snap, String path) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectByPath(snap, path, TraceObjectBreakpointLocation.class);
        }
        try (LockHold hold = LockHold.lock((Lock)this.lock.readLock());){
            TraceBreakpoint traceBreakpoint = this.getBreakpointsByPath(path).stream().filter(b -> b.isValid(snap)).findAny().orElse(null);
            return traceBreakpoint;
        }
    }

    @Override
    public Collection<? extends TraceBreakpoint> getBreakpointsAt(long snap, Address address) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsContaining(snap, address, "_range", TraceObjectBreakpointLocation.class);
        }
        return (Collection)this.delegateRead(address.getAddressSpace(), m -> m.getBreakpointsAt(snap, address), Collections.emptyList());
    }

    @Override
    public Collection<? extends TraceBreakpoint> getBreakpointsIntersecting(Lifespan span, AddressRange range) {
        if (this.trace.getObjectManager().hasSchema()) {
            return this.trace.getObjectManager().getObjectsIntersecting(span, range, "_range", TraceObjectBreakpointLocation.class);
        }
        return (Collection)this.delegateRead(range.getAddressSpace(), m -> m.getBreakpointsIntersecting(span, range), Collections.emptyList());
    }
}

