/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.table;

import docking.widgets.table.DefaultEnumeratedColumnTableModel;
import docking.widgets.table.EnumeratedColumnProgramTableModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressRange;
import ghidra.program.model.address.AddressSet;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.program.util.ProgramLocation;
import ghidra.program.util.ProgramSelection;

public class DefaultEnumeratedColumnProgramTableModel<C extends Enum<C>, R>
extends DefaultEnumeratedColumnTableModel<C, R>
implements EnumeratedColumnProgramTableModel<R> {
    protected final C selColumn;
    private Program program;

    public DefaultEnumeratedColumnProgramTableModel(PluginTool tool, String name, Class<C> colType, C selColumn) {
        super(tool, name, colType);
        Class<?> valueClass;
        if (!(selColumn == null || Address.class.isAssignableFrom(valueClass = ((DefaultEnumeratedColumnTableModel.EnumeratedTableColumn)selColumn).getValueClass()) || AddressRange.class.isAssignableFrom(valueClass) || AddressSetView.class.isAssignableFrom(valueClass))) {
            throw new IllegalArgumentException("Address-selection column must have Address, AddressRange, or AddressSetView type");
        }
        this.selColumn = selColumn;
    }

    public ProgramLocation getProgramLocation(int row, int column) {
        Class columnClass = this.getColumnClass(column);
        if (!Address.class.isAssignableFrom(columnClass) && !ProgramLocation.class.isAssignableFrom(columnClass)) {
            return null;
        }
        Object value = this.getValueAt(row, column);
        if (value instanceof Address) {
            return new ProgramLocation(this.program, (Address)value);
        }
        if (value instanceof ProgramLocation) {
            return (ProgramLocation)value;
        }
        throw new AssertionError();
    }

    public ProgramSelection getProgramSelection(int[] rows) {
        if (this.selColumn == null) {
            return null;
        }
        AddressSet sel = new AddressSet();
        for (int r : rows) {
            Object value = ((DefaultEnumeratedColumnTableModel.EnumeratedTableColumn)this.selColumn).getValueOf(this.getRowObject(r));
            if (value instanceof Address) {
                sel.add((Address)value);
                continue;
            }
            if (value instanceof AddressRange) {
                sel.add((AddressRange)value);
                continue;
            }
            if (value instanceof AddressSetView) {
                sel.add((AddressSetView)value);
                continue;
            }
            throw new AssertionError();
        }
        return new ProgramSelection((AddressSetView)sel);
    }

    public Program getProgram() {
        return this.program;
    }

    @Override
    public void setProgram(Program program) {
        this.program = program;
    }
}

