/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.jung.renderer;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.RenderContext;
import edu.uci.ics.jung.visualization.transform.shape.GraphicsDecorator;
import ghidra.app.plugin.core.functiongraph.graph.FGEdge;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.app.plugin.core.functiongraph.graph.vertex.GroupedFunctionGraphVertex;
import ghidra.graph.viewer.VisualVertex;
import ghidra.graph.viewer.vertex.VisualVertexRenderer;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.Set;

public class FGVertexRenderer
extends VisualVertexRenderer<FGVertex, FGEdge> {
    protected void paintDropShadow(RenderContext<FGVertex, FGEdge> rc, GraphicsDecorator g, Shape shape, FGVertex vertex) {
        Rectangle bounds = shape.getBounds();
        if (vertex instanceof GroupedFunctionGraphVertex) {
            Rectangle originalBounds = bounds;
            Rectangle paintBounds = (Rectangle)originalBounds.clone();
            Set<FGVertex> vertices = ((GroupedFunctionGraphVertex)vertex).getVertices();
            int offset = 15;
            int size = vertices.size();
            if (size > 3) {
                size /= 3;
                size = Math.max(size, 2);
            }
            int currentOffset = offset * size;
            for (int i = size - 1; i >= 0; --i) {
                paintBounds.x = originalBounds.x + currentOffset;
                paintBounds.y = originalBounds.y + currentOffset;
                currentOffset -= offset;
                super.paintDropShadow(rc, g, (Shape)paintBounds);
            }
        }
        super.paintDropShadow(rc, g, (Shape)bounds);
    }

    protected void paintVertexOrVertexShape(RenderContext<FGVertex, FGEdge> rc, GraphicsDecorator g, Layout<FGVertex, FGEdge> layout, FGVertex vertex, Shape compactShape, Shape fullShape) {
        if (this.isScaledPastVertexPaintingThreshold(rc)) {
            this.paintScaledVertex(rc, vertex, g, compactShape);
            return;
        }
        if (vertex instanceof GroupedFunctionGraphVertex) {
            Rectangle originalBounds = fullShape.getBounds();
            Rectangle paintBounds = (Rectangle)originalBounds.clone();
            Set<FGVertex> vertices = ((GroupedFunctionGraphVertex)vertex).getVertices();
            int offset = 5;
            int size = vertices.size();
            if (size > 3) {
                size /= 3;
                size = Math.max(size, 2);
            }
            int currentOffset = offset * size;
            for (int i = size - 1; i >= 0; --i) {
                paintBounds.x = originalBounds.x + currentOffset;
                paintBounds.y = originalBounds.y + currentOffset;
                currentOffset -= offset;
                this.paintVertex(rc, g, vertex, paintBounds, layout);
            }
        }
        Rectangle bounds = fullShape.getBounds();
        this.paintVertex(rc, g, vertex, bounds, layout);
    }

    protected void paintVertex(RenderContext<FGVertex, FGEdge> rc, GraphicsDecorator g, FGVertex vertex, Rectangle bounds, Layout<FGVertex, FGEdge> layout) {
        this.refreshVertexAsNeeded(vertex);
        vertex.setShowing(true);
        super.paintVertex(rc, g, (VisualVertex)vertex, bounds, layout);
        vertex.setShowing(false);
    }

    private void refreshVertexAsNeeded(FGVertex vertex) {
        vertex.refreshModel();
    }
}

