/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.plugintool.dialog;

import docking.Tool;
import docking.action.DockingActionIf;
import docking.action.MenuData;
import docking.actions.KeyBindingUtils;
import generic.theme.GAttributes;
import generic.theme.GColor;
import generic.theme.Gui;
import ghidra.framework.plugintool.PluginConfigurationModel;
import ghidra.framework.plugintool.PluginTool;
import ghidra.framework.plugintool.dialog.AbstractDetailsPanel;
import ghidra.framework.plugintool.util.PluginDescription;
import ghidra.framework.plugintool.util.PluginStatus;
import java.awt.Font;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.swing.KeyStroke;

class PluginDetailsPanel
extends AbstractDetailsPanel {
    private static final GColor NO_VALUE_COLOR = new GColor("color.fg.pluginpanel.details.novalue");
    private static final GColor DEPENDENCY_COLOR = new GColor("color.fg.pluginpanel.details.dependency");
    private static final GColor LOCATION_COLOR = new GColor("color.fg.pluginpanel.details.loc");
    private static final GColor DEVELOPER_COLOR = new GColor("color.fg.pluginpanel.details.developer");
    private static final GColor CLASS_COLOR = new GColor("color.fg.pluginpanel.details.class");
    private static final GColor CATEGORIES_COLOR = new GColor("color.fg.pluginpanel.details.category");
    private static final GColor TITLE_COLOR = new GColor("color.fg.pluginpanel.details.title");
    private static final GColor DESCRIPTION_COLOR = new GColor("color.fg.pluginpanel.details.description");
    private static final GColor NAME_NO_DEPENDENTS_COLOR = new GColor("color.fg.pluginpanel.details.name.no.dependents");
    private static final GColor NAME_DEPENDENTS_COLOR = new GColor("color.fg.pluginpanel.details.name.has.dependents");
    private GAttributes nameAttrs;
    private GAttributes dependenciesNameAttrs;
    private GAttributes descriptionAttrs;
    private GAttributes categoriesAttrs;
    private GAttributes classAttrs;
    private GAttributes locationAttrs;
    private GAttributes developerAttrs;
    private GAttributes dependencyAttrs;
    private GAttributes noValueAttrs;
    private final PluginConfigurationModel model;
    private PluginTool tool;
    private PluginDescription currentDescriptor;

    PluginDetailsPanel(PluginTool tool, PluginConfigurationModel model) {
        this.tool = tool;
        this.model = model;
        this.createFieldAttributes();
        this.createMainPanel();
    }

    @Override
    protected void refresh() {
        this.setPluginDescription(this.currentDescriptor);
    }

    void setPluginDescription(PluginDescription descriptor) {
        this.currentDescriptor = descriptor;
        this.textLabel.setText("");
        if (descriptor == null) {
            return;
        }
        List<PluginDescription> dependencies = this.model.getDependencies(descriptor);
        Collections.sort(dependencies, (pd1, pd2) -> pd1.getName().compareTo(pd2.getName()));
        StringBuilder buffer = new StringBuilder("<html>");
        buffer.append("<TABLE cellpadding=2>");
        this.insertRowTitle(buffer, "Name");
        this.insertRowValue(buffer, descriptor.getName(), !dependencies.isEmpty() ? this.dependenciesNameAttrs : this.nameAttrs);
        this.insertRowTitle(buffer, "Description");
        this.insertRowValue(buffer, descriptor.getDescription(), this.descriptionAttrs);
        this.insertRowTitle(buffer, "Status");
        this.insertRowValue(buffer, descriptor.getStatus().getDescription(), descriptor.getStatus() == PluginStatus.RELEASED ? titleAttrs : this.developerAttrs);
        this.insertRowTitle(buffer, "Package");
        this.insertRowValue(buffer, descriptor.getPluginPackage().getName(), this.categoriesAttrs);
        this.insertRowTitle(buffer, "Category");
        this.insertRowValue(buffer, descriptor.getCategory(), this.categoriesAttrs);
        this.insertRowTitle(buffer, "Plugin Class");
        this.insertRowValue(buffer, descriptor.getPluginClass().getName(), this.classAttrs);
        this.insertRowTitle(buffer, "Class Location");
        this.insertRowValue(buffer, descriptor.getSourceLocation(), this.locationAttrs);
        this.insertRowTitle(buffer, "Used By");
        buffer.append("<TD VALIGN=\"TOP\">");
        if (dependencies.isEmpty()) {
            this.insertHTMLLine(buffer, "None", this.noValueAttrs);
        } else {
            for (int i = 0; i < dependencies.size(); ++i) {
                this.insertHTMLString(buffer, dependencies.get(i).getPluginClass().getName(), this.dependencyAttrs);
                if (i >= dependencies.size() - 1) continue;
                buffer.append("<br>");
            }
            this.insertHTMLLine(buffer, "", titleAttrs);
        }
        buffer.append("</TD>");
        buffer.append("</TR>");
        this.insertRowTitle(buffer, "Services Required");
        buffer.append("<TD VALIGN=\"TOP\">");
        List<Class<?>> servicesRequired = descriptor.getServicesRequired();
        if (servicesRequired.isEmpty()) {
            this.insertHTMLLine(buffer, "None", this.noValueAttrs);
        } else {
            for (int i = 0; i < servicesRequired.size(); ++i) {
                this.insertHTMLString(buffer, servicesRequired.get(i).getName(), this.dependencyAttrs);
                if (i >= servicesRequired.size() - 1) continue;
                buffer.append("<br>");
            }
            this.insertHTMLLine(buffer, "", titleAttrs);
        }
        buffer.append("</TD>");
        buffer.append("</TR>");
        this.addLoadedActionsContent(buffer, descriptor);
        buffer.append("</TABLE>");
        this.textLabel.setText(buffer.toString());
        this.sp.getViewport().setViewPosition(new Point(0, 0));
    }

    private void addLoadedActionsContent(StringBuilder buffer, PluginDescription pluginDescription) {
        if (!this.model.isLoaded(pluginDescription)) {
            return;
        }
        buffer.append("<TR>");
        buffer.append("<TD VALIGN=\"TOP\">");
        this.insertHTMLLine(buffer, "Loaded Actions:", titleAttrs);
        buffer.append("</TD>");
        Set actions = Collections.emptySet();
        if (this.model.isLoaded(pluginDescription)) {
            actions = KeyBindingUtils.getKeyBindingActionsForOwner((Tool)this.tool, (String)pluginDescription.getName());
        }
        if (actions.isEmpty()) {
            buffer.append("<TD VALIGN=\"TOP\">");
            this.insertHTMLLine(buffer, "No actions for plugin", this.noValueAttrs);
            buffer.append("</TD>");
            buffer.append("</TR>");
            return;
        }
        buffer.append("<TD VALIGN=\"TOP\">");
        buffer.append("<TABLE BORDER=1><TR><TH>Action Name</TH><TH>Menu Path</TH><TH>Keybinding</TH></TR>");
        for (DockingActionIf dockableAction : actions) {
            buffer.append("<TR><TD WIDTH=\"200\">");
            this.insertHTMLString(buffer, dockableAction.getName(), this.locationAttrs);
            buffer.append("</TD>");
            buffer.append("<TD WIDTH=\"300\">");
            MenuData menuBarData = dockableAction.getMenuBarData();
            String[] menuPath = menuBarData == null ? null : menuBarData.getMenuPath();
            String menuPathString = this.createStringForMenuPath(menuPath);
            if (menuPathString != null) {
                this.insertHTMLString(buffer, menuPathString, this.locationAttrs);
            } else {
                String[] popupPath;
                MenuData popupMenuData = dockableAction.getPopupMenuData();
                String[] stringArray = popupPath = popupMenuData == null ? null : popupMenuData.getMenuPath();
                if (popupPath != null) {
                    this.insertHTMLString(buffer, "(in a context popup menu)", this.noValueAttrs);
                } else {
                    this.insertHTMLString(buffer, "Not in a menu", this.noValueAttrs);
                }
            }
            buffer.append("</TD>");
            buffer.append("<TD WIDTH=\"100\">");
            KeyStroke keyBinding = dockableAction.getKeyBinding();
            if (keyBinding != null) {
                String keyStrokeString = KeyBindingUtils.parseKeyStroke((KeyStroke)keyBinding);
                this.insertHTMLString(buffer, keyStrokeString, this.locationAttrs);
            } else {
                this.insertHTMLString(buffer, "No keybinding", this.noValueAttrs);
            }
            buffer.append("</TD></TR>");
        }
        buffer.append("</TABLE>");
        buffer.append("</TD>");
        buffer.append("</TR>");
    }

    private String createStringForMenuPath(String[] path) {
        if (path == null) {
            return null;
        }
        StringBuilder buffy = new StringBuilder();
        for (int i = 0; i < path.length; ++i) {
            buffy.append(path[i].replaceAll("\\&", ""));
            if (i == path.length - 1) continue;
            buffy.append("->");
        }
        return buffy.toString();
    }

    @Override
    protected void createFieldAttributes() {
        Font font = Gui.getFont((String)"font.panel.details");
        titleAttrs = new GAttributes(font, TITLE_COLOR);
        this.nameAttrs = new GAttributes(font, NAME_NO_DEPENDENTS_COLOR);
        this.dependenciesNameAttrs = new GAttributes(font, NAME_DEPENDENTS_COLOR);
        this.descriptionAttrs = new GAttributes(font, DESCRIPTION_COLOR);
        this.categoriesAttrs = new GAttributes(font, CATEGORIES_COLOR);
        this.locationAttrs = new GAttributes(font, LOCATION_COLOR);
        this.developerAttrs = new GAttributes(font, DEVELOPER_COLOR);
        Font fontMonospaced = Gui.getFont((String)"font.panel.details.monospaced");
        this.classAttrs = new GAttributes(fontMonospaced, CLASS_COLOR);
        this.dependencyAttrs = new GAttributes(fontMonospaced, DEPENDENCY_COLOR);
        this.noValueAttrs = new GAttributes(font, NO_VALUE_COLOR);
    }
}

