/*
 * Decompiled with CFR 0.152.
 */
package generic.stl;

import generic.stl.IteratorSTL;
import generic.stl.VectorIterator;
import java.util.ArrayList;

class ReverseVectorIterator<T>
extends VectorIterator<T> {
    public ReverseVectorIterator(ArrayList<T> data, int index) {
        super(data, index);
    }

    @Override
    public boolean isBegin() {
        return this.index == this.data.size() - 1;
    }

    @Override
    public boolean isEnd() {
        return this.index < 0;
    }

    @Override
    public T get(int offset) {
        return (T)this.data.get(this.index - offset);
    }

    @Override
    public IteratorSTL<T> decrement() {
        if (this.index == this.data.size() - 1) {
            throw new IndexOutOfBoundsException();
        }
        ++this.index;
        return this;
    }

    public void delete(int count) {
        if (this.index < count - 1) {
            throw new IndexOutOfBoundsException();
        }
        this.data.subList(this.index - count + 1, count).clear();
    }

    @Override
    public IteratorSTL<T> increment() {
        if (this.index < 0) {
            throw new IndexOutOfBoundsException();
        }
        --this.index;
        return this;
    }

    @Override
    public IteratorSTL<T> increment(int count) {
        if (this.index - count < -1) {
            throw new IndexOutOfBoundsException();
        }
        this.index -= count;
        return this;
    }

    @Override
    public IteratorSTL<T> decrement(int count) {
        if (this.index + count >= this.data.size()) {
            throw new IndexOutOfBoundsException();
        }
        this.index += count;
        return this;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj == this) {
            return true;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        ReverseVectorIterator other = (ReverseVectorIterator)obj;
        return this.data == other.data && this.index == other.index;
    }

    @Override
    public int hashCode() {
        return this.data.hashCode();
    }

    @Override
    public IteratorSTL<T> copy() {
        return new ReverseVectorIterator<T>(this.data, this.index);
    }

    @Override
    public int getIndex() {
        return this.index;
    }
}

