/*
 * Decompiled with CFR 0.152.
 */
package ghidra.generic.util.datastruct;

import ghidra.generic.util.datastruct.SortedList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public interface ValueSortedMap<K, V> {
    public V put(K var1, V var2);

    public V get(Object var1);

    public V remove(K var1);

    public ValueSortedMapEntryList<K, V> entrySet();

    public Map.Entry<K, V> lowerEntryByValue(V var1);

    public Map.Entry<K, V> floorEntryByValue(V var1);

    public Map.Entry<K, V> ceilingEntryByValue(V var1);

    public Map.Entry<K, V> higherEntryByValue(V var1);

    public ValueSortedMap<K, V> subMapByValue(V var1, boolean var2, V var3, boolean var4);

    public ValueSortedMap<K, V> headMapByValue(V var1, boolean var2);

    public ValueSortedMap<K, V> tailMapByValue(V var1, boolean var2);

    public ValueSortedMapKeyList<K> keySet();

    public boolean update(K var1);

    public SortedList<V> values();

    public boolean isEmpty();

    public boolean containsKey(Object var1);

    public boolean containsValue(Object var1);

    public int size();

    public void clear();

    public static interface ValueSortedMapKeyList<K>
    extends LesserList<K> {
    }

    public static interface ValueSortedMapEntryList<K, V>
    extends LesserList<Map.Entry<K, V>> {
    }

    public static interface LesserList<E>
    extends Iterable<E> {
        public boolean isEmpty();

        public int size();

        public E get(int var1);

        public List<E> toList();

        public ListIterator<E> listIterator(int var1);

        public int indexOf(Object var1);

        public boolean contains(Object var1);

        public E poll();

        public boolean remove(Object var1);

        default public boolean removeAll(Collection<?> col) {
            boolean result = false;
            for (Object e : col) {
                result |= this.remove(e);
            }
            return result;
        }
    }
}

