/*
 * Decompiled with CFR 0.152.
 */
package com.install4j.api.windows;

import com.install4j.api.ProcessInfo;
import com.install4j.api.Util;
import com.install4j.runtime.installer.helper.InstallerUtil;
import com.install4j.runtime.installer.helper.RunningProcessChecker;
import com.install4j.runtime.installer.platform.win32.Misc;
import java.util.Collection;

public class WinProcesses {
    public static Info[] getRunningProcesses() {
        if (!Util.isWindows()) {
            return new Info[0];
        }
        Collection<ProcessInfo> processes = RunningProcessChecker.getAllRunningProcesses();
        Info[] infos = new Info[processes.size()];
        int i = 0;
        for (ProcessInfo processInfo : processes) {
            infos[i++] = (Info)processInfo;
        }
        return infos;
    }

    public static boolean areInstalledLaunchersRunning() {
        if (!InstallerUtil.isWindows()) {
            return false;
        }
        return RunningProcessChecker.areInstalledLaunchersRunning();
    }

    public static String getWindowTitle(int processId) {
        return Misc.getWindowTitle(processId);
    }

    public static boolean terminateProcesses(int[] processIds) {
        return Misc.terminateProcesses(processIds, true, 0) == 1;
    }

    public static boolean closeProcesses(int[] processIds, int timeout2) {
        return Misc.terminateProcesses(processIds, false, timeout2) == 1;
    }

    public static class Info
    extends ProcessInfo {
        public Info(int processId, String moduleName) {
            super(processId, moduleName);
        }

        @Override
        public String getWindowTitle() {
            return WinProcesses.getWindowTitle(this.getProcessId());
        }

        @Override
        public String toString() {
            return "Info{" + super.toString();
        }
    }
}

