/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialogEinstellungen;

import java.awt.Color;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import mediathek.config.MVConfig;
import mediathek.file.GetFile;
import mediathek.gui.dialog.DialogHilfe;
import mediathek.tool.GuiFunktionenProgramme;
import mediathek.tool.SVGIconUtilities;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PanelProgrammPfade
extends JPanel {
    public JDialog dialog;
    private final boolean vlc;
    private final boolean ffmpeg;
    private final JFrame parentComponent;
    private static final Logger logger = LogManager.getLogger();
    private JButton jButtonFFmpegPfad;
    private JButton jButtonFFmpegSuchen;
    private JButton jButtonHilfe;
    private JButton jButtonVlcPfad;
    private JButton jButtonVlcSuchen;
    private JPanel jPanelFFmpeg;
    private JPanel jPanelVlc;
    private JTextField jTextFieldFFmpeg;
    private JTextField jTextFieldVlc;

    public PanelProgrammPfade(JFrame parentFrame, boolean vvlc, boolean fffmpeg) {
        this.initComponents();
        this.vlc = vvlc;
        this.ffmpeg = fffmpeg;
        this.parentComponent = parentFrame;
        this.init();
        this.initBeob();
    }

    private void init() {
        this.jButtonVlcPfad.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonFFmpegPfad.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/folder-open.svg"));
        this.jButtonHilfe.setIcon(SVGIconUtilities.createSVGIcon("icons/fontawesome/circle-question.svg"));
        this.jPanelVlc.setVisible(this.vlc);
        this.jPanelFFmpeg.setVisible(this.ffmpeg);
        if (MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_VLC).isEmpty()) {
            MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_VLC, GuiFunktionenProgramme.getMusterPfadVlc());
        }
        if (MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_FFMPEG).isEmpty()) {
            MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_FFMPEG, GuiFunktionenProgramme.getMusterPfadFFmpeg());
        }
        this.jTextFieldVlc.setText(MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_VLC));
        this.jTextFieldFFmpeg.setText(MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_FFMPEG));
    }

    private void initBeob() {
        this.jTextFieldVlc.getDocument().addDocumentListener(new BeobDoc());
        this.jTextFieldFFmpeg.getDocument().addDocumentListener(new BeobDoc());
        this.jButtonVlcPfad.addActionListener(new BeobPfad(this.jTextFieldVlc));
        this.jButtonFFmpegPfad.addActionListener(new BeobPfad(this.jTextFieldFFmpeg));
        this.jButtonVlcSuchen.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_VLC, "");
            this.jTextFieldVlc.setText(GuiFunktionenProgramme.getMusterPfadVlc());
        });
        this.jButtonFFmpegSuchen.addActionListener(e -> {
            MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_FFMPEG, "");
            this.jTextFieldFFmpeg.setText(GuiFunktionenProgramme.getMusterPfadFFmpeg());
        });
        this.jButtonHilfe.addActionListener(e -> new DialogHilfe(this.parentComponent, true, new GetFile().getHilfeSuchen("hilfetext_standardPset.txt")).setVisible(true));
    }

    private void check() {
        MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_VLC, this.jTextFieldVlc.getText());
        MVConfig.add(MVConfig.Configs.SYSTEM_PFAD_FFMPEG, this.jTextFieldFFmpeg.getText());
        try {
            if (this.jTextFieldVlc.getText().isEmpty()) {
                this.jTextFieldVlc.setBackground(new Color(255, 200, 200));
            } else if (!new File(MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_VLC)).exists()) {
                this.jTextFieldVlc.setBackground(new Color(255, 200, 200));
            } else {
                this.jTextFieldVlc.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        }
        catch (Exception ex) {
            this.jTextFieldVlc.setBackground(new Color(255, 200, 200));
        }
        try {
            if (this.jTextFieldFFmpeg.getText().isEmpty()) {
                this.jTextFieldFFmpeg.setBackground(new Color(255, 200, 200));
            } else if (!new File(MVConfig.get(MVConfig.Configs.SYSTEM_PFAD_FFMPEG)).exists()) {
                this.jTextFieldFFmpeg.setBackground(new Color(255, 200, 200));
            } else {
                this.jTextFieldFFmpeg.setBackground(UIManager.getDefaults().getColor("TextField.background"));
            }
        }
        catch (Exception ex) {
            this.jTextFieldFFmpeg.setBackground(new Color(255, 200, 200));
        }
    }

    private void initComponents() {
        JScrollPane jScrollPane1 = new JScrollPane();
        JPanel jPanel1 = new JPanel();
        this.jPanelVlc = new JPanel();
        this.jTextFieldVlc = new JTextField();
        this.jButtonVlcPfad = new JButton();
        this.jButtonVlcSuchen = new JButton();
        this.jButtonHilfe = new JButton();
        this.jPanelFFmpeg = new JPanel();
        this.jTextFieldFFmpeg = new JTextField();
        this.jButtonFFmpegSuchen = new JButton();
        this.jButtonFFmpegPfad = new JButton();
        this.jPanelVlc.setBorder(BorderFactory.createTitledBorder("Pfad zum VLC-Player ausw\u00e4hlen"));
        this.jButtonVlcPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonVlcPfad.setToolTipText("Programm ausw\u00e4hlen");
        this.jButtonVlcSuchen.setText("suchen");
        this.jButtonVlcSuchen.setToolTipText("nach dem Programm suchen");
        GroupLayout jPanelVlcLayout = new GroupLayout(this.jPanelVlc);
        this.jPanelVlc.setLayout(jPanelVlcLayout);
        jPanelVlcLayout.setHorizontalGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelVlcLayout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldVlc).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonVlcPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonVlcSuchen).addContainerGap()));
        jPanelVlcLayout.setVerticalGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelVlcLayout.createSequentialGroup().addContainerGap().addGroup(jPanelVlcLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldVlc, -2, -1, -2).addComponent(this.jButtonVlcPfad).addComponent(this.jButtonVlcSuchen)).addContainerGap()));
        jPanelVlcLayout.linkSize(1, this.jButtonVlcPfad, this.jTextFieldVlc);
        this.jButtonHilfe.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-help.png")));
        this.jButtonHilfe.setToolTipText("Hilfe anzeigen");
        this.jPanelFFmpeg.setBorder(BorderFactory.createTitledBorder("Pfad zu ffmpeg ausw\u00e4hlen"));
        this.jButtonFFmpegSuchen.setText("suchen");
        this.jButtonFFmpegSuchen.setToolTipText("nach dem Programm suchen");
        this.jButtonFFmpegPfad.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonFFmpegPfad.setToolTipText("Programm ausw\u00e4hlen");
        GroupLayout jPanelFFmpegLayout = new GroupLayout(this.jPanelFFmpeg);
        this.jPanelFFmpeg.setLayout(jPanelFFmpegLayout);
        jPanelFFmpegLayout.setHorizontalGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFFmpegLayout.createSequentialGroup().addContainerGap().addComponent(this.jTextFieldFFmpeg, -1, 345, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFFmpegPfad).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFFmpegSuchen).addContainerGap()));
        jPanelFFmpegLayout.setVerticalGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelFFmpegLayout.createSequentialGroup().addContainerGap().addGroup(jPanelFFmpegLayout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(this.jTextFieldFFmpeg, -2, -1, -2).addComponent(this.jButtonFFmpegPfad).addComponent(this.jButtonFFmpegSuchen)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelFFmpegLayout.linkSize(1, this.jButtonFFmpegPfad, this.jButtonFFmpegSuchen, this.jTextFieldFFmpeg);
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jPanelVlc, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonHilfe)).addComponent(this.jPanelFFmpeg, -1, -1, Short.MAX_VALUE)).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jPanelVlc, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelFFmpeg, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonHilfe).addContainerGap(84, Short.MAX_VALUE)));
        jScrollPane1.setViewportView(jPanel1);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1).addContainerGap()));
    }

    private class BeobDoc
    implements DocumentListener {
        private BeobDoc() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            PanelProgrammPfade.this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            PanelProgrammPfade.this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            PanelProgrammPfade.this.check();
        }
    }

    private class BeobPfad
    implements ActionListener {
        private final JTextField textField;

        public BeobPfad(JTextField ttextField) {
            this.textField = ttextField;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog((Frame)PanelProgrammPfade.this.parentComponent, "Programmdatei ausw\u00e4hlen");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        this.textField.setText(new File(chooser.getDirectory() + chooser.getFile()).getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error(ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                chooser.setFileSelectionMode(0);
                chooser.setFileHidingEnabled(false);
                if (this.textField.getText().isEmpty()) {
                    chooser.setCurrentDirectory(new File(SystemUtils.USER_HOME));
                } else {
                    chooser.setCurrentDirectory(new File(this.textField.getText()));
                }
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        this.textField.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error(ex);
                    }
                }
            }
        }
    }
}

