/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.filter;

import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schema.Routine;
import schemacrawler.schema.RoutineParameter;
import schemacrawler.schemacrawler.GrepOptions;
import us.fatehi.utility.string.StringFormat;

class RoutineGrepFilter
implements Predicate<Routine> {
    private static final Logger LOGGER = Logger.getLogger(RoutineGrepFilter.class.getName());
    private final GrepOptions options;

    public RoutineGrepFilter(GrepOptions options) {
        this.options = Objects.requireNonNull(options, "No grep options provided");
    }

    @Override
    public boolean test(Routine routine) {
        boolean include;
        boolean checkIncludeForParameters = this.options.isGrepRoutineParameters();
        boolean checkIncludeForDefinitions = this.options.isGrepDefinitions();
        if (!checkIncludeForParameters && !checkIncludeForDefinitions) {
            return true;
        }
        InclusionRule grepDefinitionInclusionRule = this.options.grepDefinitionInclusionRule();
        boolean includeForColumns = false;
        boolean includeForDefinitions = false;
        for (RoutineParameter parameter : routine.getParameters()) {
            if (checkIncludeForParameters && this.options.grepRoutineParameterInclusionRule().test(parameter.getFullName())) {
                includeForColumns = true;
                break;
            }
            if (!checkIncludeForDefinitions || !grepDefinitionInclusionRule.test(parameter.getRemarks())) continue;
            includeForDefinitions = true;
            break;
        }
        if (checkIncludeForDefinitions) {
            if (grepDefinitionInclusionRule.test(routine.getRemarks())) {
                includeForDefinitions = true;
            }
            if (grepDefinitionInclusionRule.test(routine.getDefinition())) {
                includeForDefinitions = true;
            }
        }
        boolean bl = include = checkIncludeForParameters && includeForColumns || checkIncludeForDefinitions && includeForDefinitions;
        if (this.options.grepInvertMatch()) {
            boolean bl2 = include = !include;
        }
        if (!include) {
            LOGGER.log(Level.FINE, (Supplier<String>)new StringFormat("Excluding routine <%s>", new Object[]{routine}));
        }
        return include;
    }
}

