/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.tools.text.formatter.base.helper;

import java.io.PrintWriter;
import schemacrawler.tools.command.text.schema.options.TextOutputFormat;
import schemacrawler.tools.text.formatter.base.helper.BaseTextFormattingHelper;
import schemacrawler.tools.text.formatter.base.helper.TextFormattingHelper;
import us.fatehi.utility.Color;
import us.fatehi.utility.IOUtility;
import us.fatehi.utility.Utility;
import us.fatehi.utility.html.Tag;
import us.fatehi.utility.html.TagBuilder;
import us.fatehi.utility.html.TagOutputFormat;

public final class HtmlFormattingHelper
extends BaseTextFormattingHelper {
    private static final String HTML_HEADER = HtmlFormattingHelper.htmlHeader();
    private static final String HTML_FOOTER = "</body>" + System.lineSeparator() + "</html>";

    private static String htmlHeader() {
        StringBuilder styleSheet = new StringBuilder(4096);
        styleSheet.append(System.lineSeparator()).append(IOUtility.readResourceFully("/sc.css")).append(System.lineSeparator()).append(IOUtility.readResourceFully("/sc_output.css")).append(System.lineSeparator());
        String htmlHeaderTemplate = IOUtility.readResourceFully("/html.header.txt");
        String htmlHeader = htmlHeaderTemplate.formatted(styleSheet);
        return htmlHeader;
    }

    public HtmlFormattingHelper(PrintWriter out, TextOutputFormat outputFormat) {
        super(out, outputFormat);
    }

    @Override
    public String createLeftArrow() {
        return "\u2190";
    }

    @Override
    public String createRightArrow() {
        return "\u2192";
    }

    @Override
    public String createWeakLeftArrow() {
        return "\u21dc";
    }

    @Override
    public String createWeakRightArrow() {
        return "\u21dd";
    }

    @Override
    public void writeDocumentEnd() {
        this.out.println(HTML_FOOTER);
    }

    @Override
    public void writeDocumentStart() {
        this.out.println(HTML_HEADER);
    }

    @Override
    public void writeHeader(TextFormattingHelper.DocumentHeaderType type, String header) {
        if (!Utility.isBlank(header) && type != null) {
            this.out.println("%s%n<%s>%s</%s>%n".formatted(type.getPrefix(), type.getHeaderTag(), header, type.getHeaderTag()));
        }
    }

    @Override
    public void writeObjectEnd() {
        this.out.append("</table>").println();
        this.out.println("<p>&#160;</p>");
        this.out.println();
    }

    @Override
    public void writeObjectNameRow(String id, String name, String description, Color backgroundColor) {
        Tag span;
        Tag caption = TagBuilder.caption().withStyle("background-color: %s;".formatted(backgroundColor)).make();
        if (!Utility.isBlank(name)) {
            span = TagBuilder.span().withEscapedText(name).withStyleClass("caption_name").make();
            if (!Utility.isBlank(id)) {
                span.addAttribute("id", id);
            }
            caption.addInnerTag(span);
        }
        if (!Utility.isBlank(description)) {
            span = TagBuilder.span().withEscapedText(description).withStyleClass("caption_description").make();
            caption.addInnerTag(span);
        }
        StringBuilder buffer = new StringBuilder(1024);
        buffer.append(caption.render(TagOutputFormat.html)).append(System.lineSeparator());
        this.out.println(buffer.toString());
    }

    @Override
    public void writeObjectStart() {
        this.out.println("<table>");
    }
}

