/*
 * Decompiled with CFR 0.152.
 */
package sarif.managers;

import com.google.gson.JsonArray;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.model.address.Address;
import ghidra.program.model.address.AddressFormatException;
import ghidra.program.model.address.AddressOverflowException;
import ghidra.program.model.listing.GhidraClass;
import ghidra.program.model.listing.Library;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.ExternalLocation;
import ghidra.program.model.symbol.ExternalManager;
import ghidra.program.model.symbol.Namespace;
import ghidra.program.model.symbol.SourceType;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.exception.InvalidInputException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskLauncher;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import sarif.SarifProgramOptions;
import sarif.export.SarifWriterTask;
import sarif.export.extlib.SarifClassesNamespaceWriter;
import sarif.export.extlib.SarifExternalLibraryWriter;
import sarif.managers.SarifMgr;

public class ExternalLibSarifMgr
extends SarifMgr {
    public static String KEY = "EXT_LIBRARY";
    public static String SUBKEY0 = "External.Library";
    public static String SUBKEY1 = "External.Location";
    private ExternalManager extManager;
    private boolean libraries = true;

    ExternalLibSarifMgr(Program program, MessageLog log) {
        super(KEY, program, log);
        this.extManager = program.getExternalManager();
        externalMap = new HashMap();
    }

    @Override
    protected void readResults(List<Map<String, Object>> list, SarifProgramOptions options, TaskMonitor monitor) throws AddressFormatException, CancelledException {
        if (list != null) {
            monitor.setMessage("Processing " + this.key + "...");
            monitor.setMaximum((long)(list.size() * 2));
            for (Map<String, Object> result : list) {
                monitor.checkCancelled();
                this.read(result, options, monitor);
                monitor.increment();
            }
            this.libraries = false;
            for (Map<String, Object> result : list) {
                monitor.checkCancelled();
                this.read(result, options, monitor);
                monitor.increment();
            }
        } else {
            monitor.setMessage("Skipping over " + this.key + " ...");
        }
    }

    @Override
    public boolean read(Map<String, Object> result, SarifProgramOptions options, TaskMonitor monitor) throws CancelledException {
        try {
            String symbol = (String)result.get("symbol");
            if (this.libraries && symbol == null) {
                this.processExternalLib(result);
                return true;
            }
            if (!this.libraries && symbol != null) {
                this.processExternalLocation(result);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            this.log.appendException((Throwable)e);
            return false;
        }
    }

    private void processExternalLib(Map<String, Object> result) throws InvalidInputException, DuplicateNameException {
        String progName = (String)result.get("name");
        Library library = this.extManager.getExternalLibrary(progName);
        if (library != null) {
            return;
        }
        String source = (String)result.get("sourceType");
        SourceType sourceType = this.getSourceType(source);
        if (sourceType.equals((Object)SourceType.DEFAULT)) {
            sourceType = SourceType.IMPORTED;
        }
        library = this.extManager.addExternalLibraryName(progName, sourceType);
    }

    private void processExternalLocation(Map<String, Object> result) throws IOException {
        try {
            String name = (String)result.get("name");
            String location = (String)result.get("location");
            Address address = this.getLocation(result);
            String extern = (String)result.get("externalAddress");
            String source = (String)result.get("source");
            SourceType sourceType = this.getSourceType(source);
            if (sourceType.equals((Object)SourceType.DEFAULT)) {
                sourceType = SourceType.IMPORTED;
            }
            boolean isClass = (Boolean)result.get("isClass");
            Namespace p = this.walkNamespace(this.program.getGlobalNamespace(), location + "::", address, sourceType, isClass);
            String name0 = (String)result.get("originalImportedName");
            ExternalLocation loc = this.addExternal(result, name, address, sourceType, p, name0);
            externalMap.put(extern, loc);
        }
        catch (AddressOverflowException | InvalidInputException e) {
            this.log.appendException(e);
        }
    }

    private ExternalLocation addExternal(Map<String, Object> result, String name, Address address, SourceType sourceType, Namespace p, String name0) throws InvalidInputException {
        ExternalLocation loc;
        Library lib = this.getLibrary(p);
        if (((Boolean)result.get("isFunction")).booleanValue()) {
            if (name0 != null) {
                loc = this.extManager.addExtFunction((Namespace)(lib == null ? p : lib), name0, address, sourceType, false);
                loc.setName(p, name, sourceType);
            } else {
                loc = this.extManager.addExtFunction(p, name, address, sourceType, true);
            }
        } else if (name0 != null) {
            loc = this.extManager.addExtLocation((Namespace)(lib == null ? p : lib), name0, address, sourceType, false);
            loc.setName(p, name, sourceType);
        } else {
            loc = this.extManager.addExtLocation(p, name, address, sourceType, true);
        }
        return loc;
    }

    private Library getLibrary(Namespace p) {
        if (p instanceof Library) {
            Library lib = (Library)p;
            return lib;
        }
        Namespace parent = p.getParentNamespace();
        return parent == null ? null : this.getLibrary(parent);
    }

    void write(JsonArray results, TaskMonitor monitor) throws IOException, CancelledException {
        monitor.setMessage("Writing EXTERNAL LIBRARIES ...");
        String[] externalNames = this.extManager.getExternalLibraryNames();
        ArrayList<String> request0 = new ArrayList<String>();
        for (String name : externalNames) {
            request0.add(name);
        }
        ExternalLibSarifMgr.writeExtAsSARIF(this.program, request0, results);
        Iterator classNamespaces = this.program.getSymbolTable().getClassNamespaces();
        ArrayList<GhidraClass> request1 = new ArrayList<GhidraClass>();
        while (classNamespaces.hasNext()) {
            request1.add((GhidraClass)classNamespaces.next());
        }
        ExternalLibSarifMgr.writeNamespaceAsSARIF(this.program, request1, results);
    }

    public static void writeExtAsSARIF(Program program, List<String> request, JsonArray results) throws IOException {
        SarifExternalLibraryWriter writer = new SarifExternalLibraryWriter(program.getExternalManager(), request, null);
        new TaskLauncher((Task)new SarifWriterTask("Libraries", writer, results), null);
    }

    public static void writeNamespaceAsSARIF(Program program, List<GhidraClass> request, JsonArray results) throws IOException {
        SarifClassesNamespaceWriter writer = new SarifClassesNamespaceWriter(program.getExternalManager(), program.getSymbolTable(), request, null);
        new TaskLauncher((Task)new SarifWriterTask("Libraries", writer, results), null);
    }
}

