/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.decompiler.component;

import docking.widgets.EventTrigger;
import docking.widgets.fieldpanel.field.Field;
import docking.widgets.fieldpanel.support.FieldLocation;
import generic.theme.GColor;
import ghidra.app.decompiler.ClangFunction;
import ghidra.app.decompiler.ClangNode;
import ghidra.app.decompiler.ClangSyntaxToken;
import ghidra.app.decompiler.ClangToken;
import ghidra.app.decompiler.ClangTokenGroup;
import ghidra.app.decompiler.DecompilerHighlighter;
import ghidra.app.decompiler.component.ClangDecompilerHighlighter;
import ghidra.app.decompiler.component.ClangHighlightListener;
import ghidra.app.decompiler.component.ColorProvider;
import ghidra.app.decompiler.component.DecompilerUtils;
import ghidra.app.decompiler.component.DefaultColorProvider;
import ghidra.app.decompiler.component.HighlightToken;
import ghidra.app.decompiler.component.NullClangHighlightController;
import ghidra.app.decompiler.component.TokenHighlightColors;
import ghidra.app.decompiler.component.TokenHighlights;
import ghidra.app.decompiler.component.UserHighlights;
import ghidra.program.model.listing.Function;
import ghidra.program.model.pcode.HighFunction;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Supplier;
import util.CollectionUtils;

public abstract class ClangHighlightController {
    public static Color DEFAULT_HIGHLIGHT_COLOR = new GColor("color.bg.decompiler.highlights.default");
    protected Color defaultHighlightColor = DEFAULT_HIGHLIGHT_COLOR;
    protected Color defaultParenColor = DEFAULT_HIGHLIGHT_COLOR;
    private TokenHighlights contextHighlightTokens = new TokenHighlights();
    private UserHighlights userHighlights = new UserHighlights();
    private long updateId;
    private int maxColorBlendSize = 5;
    private boolean isRebuilding;
    private List<ClangHighlightListener> listeners = new ArrayList<ClangHighlightListener>();

    public static ClangHighlightController dummyIfNull(ClangHighlightController c) {
        if (c == null) {
            return new NullClangHighlightController();
        }
        return c;
    }

    public abstract void fieldLocationChanged(FieldLocation var1, Field var2, EventTrigger var3);

    void setHighlightColor(Color c) {
        this.defaultHighlightColor = c;
    }

    public ColorProvider getGeneratedColorProvider() {
        return new GeneratedColorProvider();
    }

    public long getUpdateId() {
        return this.updateId;
    }

    public boolean hasContextHighlight(ClangToken token) {
        return this.contextHighlightTokens.contains(token);
    }

    public boolean hasSecondaryHighlight(ClangToken token) {
        return this.getSecondaryHighlight(token) != null;
    }

    public boolean hasSecondaryHighlights(Function function) {
        return this.userHighlights.hasSecondaryHighlights(function);
    }

    public Color getSecondaryHighlight(ClangToken token) {
        return this.userHighlights.getSecondaryHighlight(token);
    }

    public TokenHighlightColors getSecondaryHighlightColors() {
        return this.userHighlights.getSecondaryHighlightColors();
    }

    public TokenHighlights getPrimaryHighlights() {
        return this.contextHighlightTokens;
    }

    public Set<DecompilerHighlighter> getSecondaryHighlighters(Function function) {
        return this.userHighlights.getSecondaryHighlighters(function);
    }

    public Set<DecompilerHighlighter> getServiceHighlighters() {
        return this.userHighlights.getServiceHighlighters();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reapplyAllHighlights(Function function) {
        this.isRebuilding = true;
        Set<DecompilerHighlighter> service = this.getServiceHighlighters();
        Set<DecompilerHighlighter> secondary = this.getSecondaryHighlighters(function);
        Iterable it = CollectionUtils.asIterable((Iterable[])new Iterable[]{service, secondary});
        try {
            for (DecompilerHighlighter highlighter : it) {
                highlighter.clearHighlights();
                highlighter.applyHighlights();
            }
        }
        finally {
            this.isRebuilding = false;
        }
        HashSet<ClangToken> allTokens = new HashSet<ClangToken>();
        it = CollectionUtils.asIterable((Iterable[])new Iterable[]{service, secondary});
        for (DecompilerHighlighter highlighter : it) {
            TokenHighlights hlTokens = this.userHighlights.add(highlighter);
            for (HighlightToken hlToken : hlTokens) {
                allTokens.add(hlToken.getToken());
            }
        }
        for (ClangToken token : allTokens) {
            this.updateHighlightColor(token);
        }
    }

    public TokenHighlights getHighlighterHighlights(DecompilerHighlighter highlighter) {
        return this.userHighlights.getHighlights(highlighter);
    }

    public ClangToken getHighlightedToken() {
        if (this.contextHighlightTokens.size() == 1) {
            HighlightToken hlToken = (HighlightToken)CollectionUtils.any((Iterable)this.contextHighlightTokens);
            return hlToken.getToken();
        }
        return null;
    }

    private void gatherAllTokens(ClangNode parentNode, Set<ClangToken> results) {
        int n = parentNode.numChildren();
        for (int i = 0; i < n; ++i) {
            ClangNode node = parentNode.Child(i);
            if (node.numChildren() > 0) {
                this.gatherAllTokens(node, results);
                continue;
            }
            if (!(node instanceof ClangToken)) continue;
            results.add((ClangToken)node);
        }
    }

    public void clearPrimaryHighlights() {
        Consumer<ClangToken> clearAll = token -> {
            token.setMatchingToken(false);
            this.updateHighlightColor((ClangToken)token);
        };
        this.doClearHighlights(this.contextHighlightTokens, clearAll);
        this.notifyListeners();
    }

    private void doClearHighlights(TokenHighlights tokenHighlights, Consumer<ClangToken> clearer) {
        Iterator<HighlightToken> it = tokenHighlights.iterator();
        while (it.hasNext()) {
            HighlightToken highlight = it.next();
            it.remove();
            ClangToken token = highlight.getToken();
            clearer.accept(token);
        }
    }

    public void togglePrimaryHighlights(Color hlColor, Supplier<List<ClangToken>> tokens) {
        boolean isAllHighlighted = true;
        for (ClangToken token : tokens.get()) {
            if (this.hasContextHighlight(token)) continue;
            isAllHighlighted = false;
            break;
        }
        this.clearPrimaryHighlights();
        if (isAllHighlighted) {
            return;
        }
        this.addPrimaryHighlights(tokens, hlColor);
    }

    public void removeSecondaryHighlights(Function f) {
        List<DecompilerHighlighter> highlighters = this.userHighlights.getSecondaryHighlightersByFunction(f);
        for (DecompilerHighlighter highlighter : highlighters) {
            TokenHighlights highlights = this.userHighlights.getHighlights(highlighter);
            Consumer<ClangToken> clearHighlight = token -> this.updateHighlightColor((ClangToken)token);
            this.doClearHighlights(highlights, clearHighlight);
        }
        highlighters.clear();
        this.notifyListeners();
    }

    public void removeSecondaryHighlights(ClangToken token) {
        DecompilerHighlighter highlighter = this.userHighlights.getSecondaryHighlighter(token);
        if (highlighter != null) {
            highlighter.dispose();
        }
        this.notifyListeners();
    }

    public void removeHighlighter(DecompilerHighlighter highlighter) {
        this.removeHighlighterHighlights(highlighter);
        this.userHighlights.remove(highlighter);
    }

    public void removeHighlighterHighlights(DecompilerHighlighter highlighter) {
        TokenHighlights highlighterTokens = this.userHighlights.get(highlighter);
        if (highlighterTokens == null) {
            return;
        }
        Consumer<ClangToken> clearHighlight = token -> this.updateHighlightColor((ClangToken)token);
        this.doClearHighlights(highlighterTokens, clearHighlight);
        this.notifyListeners();
    }

    public void addSecondaryHighlighter(Function function, DecompilerHighlighter highlighter) {
        this.userHighlights.addSecondaryHighlighter(function, highlighter);
    }

    public void addHighlighter(ClangDecompilerHighlighter highlighter) {
        this.userHighlights.add(highlighter);
    }

    public void addHighlighterHighlights(DecompilerHighlighter highlighter, Supplier<? extends Collection<ClangToken>> tokens, ColorProvider colorProvider) {
        Objects.requireNonNull(highlighter);
        TokenHighlights highlighterTokens = this.userHighlights.add(highlighter);
        this.addTokensToHighlights(tokens.get(), colorProvider, highlighterTokens);
    }

    private void addPrimaryHighlights(Supplier<? extends Collection<ClangToken>> tokens, Color hlColor) {
        this.addPrimaryHighlights(tokens.get(), hlColor);
    }

    private void addPrimaryHighlights(Collection<ClangToken> tokens, Color hlColor) {
        DefaultColorProvider colorProvider = new DefaultColorProvider("Tokens Highlight Color", hlColor);
        this.addTokensToHighlights(tokens, colorProvider, this.contextHighlightTokens);
    }

    public void addPrimaryHighlights(ClangNode parentNode, final Set<PcodeOp> ops, final Color hlColor) {
        DefaultColorProvider colorProvider = new DefaultColorProvider(this, "PcodeOp Highlight Color", hlColor){

            @Override
            public Color getColor(ClangToken token) {
                PcodeOp op = token.getPcodeOp();
                return ops.contains(op) ? hlColor : null;
            }
        };
        this.addPrimaryHighlights(parentNode, colorProvider);
    }

    public void addPrimaryHighlights(ClangNode parentNode, ColorProvider colorProvider) {
        HashSet<ClangToken> tokens = new HashSet<ClangToken>();
        this.gatherAllTokens(parentNode, tokens);
        this.addTokensToHighlights(tokens, colorProvider, this.contextHighlightTokens);
    }

    private void addTokensToHighlights(Collection<ClangToken> tokens, ColorProvider colorProvider, TokenHighlights currentHighlights) {
        ++this.updateId;
        for (ClangToken clangToken : tokens) {
            Color color = colorProvider.getColor(clangToken);
            this.doAddHighlight(clangToken, color, currentHighlights);
        }
        this.notifyListeners();
    }

    protected void addPrimaryHighlight(ClangToken token, Color highlightColor) {
        this.addPrimaryHighlights(Set.of(token), highlightColor);
    }

    private void doAddHighlight(ClangToken clangToken, Color highlightColor, TokenHighlights currentHighlights) {
        if (highlightColor == null) {
            return;
        }
        currentHighlights.add(new HighlightToken(clangToken, highlightColor));
        this.updateHighlightColor(clangToken);
    }

    private void updateHighlightColor(ClangToken t) {
        if (this.isRebuilding) {
            return;
        }
        Color combinedColor = this.getCombinedColor(t);
        t.setHighlight(combinedColor);
    }

    private void add(Set<Color> colors, HighlightToken hlToken) {
        if (hlToken != null) {
            colors.add(hlToken.getColor());
        }
    }

    private void add(Set<Color> colors, Color c) {
        if (c != null) {
            colors.add(c);
        }
    }

    public Color getCombinedColor(ClangToken t) {
        HighlightToken primaryHl = this.contextHighlightTokens.get(t);
        Color blendedHlColor = this.blendHighlighterColors(t);
        HashSet<Color> allColors = new HashSet<Color>();
        this.add(allColors, primaryHl);
        this.add(allColors, blendedHlColor);
        return this.blend(allColors);
    }

    public Color blend(Set<Color> colors) {
        if (colors.isEmpty()) {
            return null;
        }
        Iterator<Color> it = colors.iterator();
        Color lastColor = it.next();
        while (it.hasNext()) {
            Color nextColor = it.next();
            lastColor = ColorUtils.blend((Color)lastColor, (Color)nextColor, (double)0.8f);
        }
        return lastColor;
    }

    private Color blendHighlighterColors(ClangToken token) {
        Function function = this.getFunction(token);
        if (function == null) {
            return null;
        }
        Set<DecompilerHighlighter> service = this.getServiceHighlighters();
        Set<DecompilerHighlighter> secondary = this.getSecondaryHighlighters(function);
        Iterable it = CollectionUtils.asIterable((Iterable[])new Iterable[]{service, secondary});
        HashSet<Color> colors = new HashSet<Color>();
        for (DecompilerHighlighter highlighter : it) {
            TokenHighlights highlights = this.userHighlights.get(highlighter);
            HighlightToken hlToken = highlights.get(token);
            if (hlToken == null) continue;
            Color nextColor = hlToken.getColor();
            colors.add(nextColor);
            if (colors.size() != this.maxColorBlendSize) continue;
            break;
        }
        return this.blend(colors);
    }

    private Function getFunction(ClangToken t) {
        ClangFunction cFunction = t.getClangFunction();
        if (cFunction == null) {
            return null;
        }
        HighFunction highFunction = cFunction.getHighFunction();
        if (highFunction == null) {
            return null;
        }
        return highFunction.getFunction();
    }

    protected void addPrimaryHighlightToTokensForBrace(ClangSyntaxToken token, Color highlightColor) {
        if (DecompilerUtils.isBrace(token)) {
            this.highlightBrace(token, highlightColor);
            this.notifyListeners();
        }
    }

    private void highlightBrace(ClangSyntaxToken startToken, Color highlightColor) {
        ClangSyntaxToken matchingBrace = DecompilerUtils.getMatchingBrace(startToken);
        if (matchingBrace != null) {
            matchingBrace.setMatchingToken(true);
            this.addPrimaryHighlights(Set.of(matchingBrace), highlightColor);
        }
    }

    protected List<ClangToken> addPrimaryHighlightToTokensForParenthesis(ClangSyntaxToken tok, Color highlightColor) {
        int paren = tok.getOpen();
        if (paren == -1) {
            paren = tok.getClose();
        }
        if (paren == -1) {
            return new ArrayList<ClangToken>();
        }
        List<ClangToken> results = this.gatherContentsOfParenthesis(tok, paren);
        this.addPrimaryHighlights(results, highlightColor);
        return results;
    }

    private List<ClangToken> gatherContentsOfParenthesis(ClangSyntaxToken tok, int parenId) {
        ArrayList<ClangToken> results = new ArrayList<ClangToken>();
        int parenCount = 0;
        ClangNode par = tok.Parent();
        while (par != null) {
            boolean outside = true;
            if (!(par instanceof ClangTokenGroup)) {
                par = par.Parent();
                continue;
            }
            ArrayList<ClangNode> list = new ArrayList<ClangNode>();
            ((ClangTokenGroup)par).flatten(list);
            for (ClangNode node : list) {
                ClangToken tk = (ClangToken)node;
                if (tk instanceof ClangSyntaxToken) {
                    ClangSyntaxToken syn = (ClangSyntaxToken)tk;
                    if (syn.getOpen() == parenId) {
                        ++parenCount;
                        outside = false;
                    } else if (syn.getClose() == parenId) {
                        ++parenCount;
                        outside = true;
                        results.add(syn);
                    }
                }
                if (!outside) {
                    results.add(tk);
                }
                if (parenCount != 2) continue;
                return results;
            }
            par = par.Parent();
        }
        return results;
    }

    public void addListener(ClangHighlightListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(ClangHighlightListener listener) {
        this.listeners.remove(listener);
    }

    protected void notifyListeners() {
        for (ClangHighlightListener listener : this.listeners) {
            listener.tokenHighlightsChanged();
        }
    }

    public void dispose() {
        this.listeners.clear();
        this.contextHighlightTokens.clear();
        this.userHighlights.dispose();
    }

    private class GeneratedColorProvider
    implements ColorProvider {
        private GeneratedColorProvider() {
        }

        @Override
        public Color getColor(ClangToken token) {
            return ClangHighlightController.this.userHighlights.getSecondaryColor(token.getText());
        }

        public String toString() {
            return "Generated Color Provider " + ClangHighlightController.this.userHighlights.getAppliedColorsString();
        }
    }
}

