/*
 * Decompiled with CFR 0.152.
 */
package ghidra.pcode.emu.jit.analysis;

import ghidra.pcode.emu.jit.JitPassage;
import ghidra.pcode.emu.jit.analysis.JitAnalysisContext;
import ghidra.pcode.exec.PcodeProgram;
import ghidra.program.model.pcode.PcodeOp;
import ghidra.program.model.pcode.SequenceNumber;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.SequencedMap;

public class JitControlFlowModel {
    private final JitPassage passage;
    private final SequencedMap<PcodeOp, JitBlock> blocks;

    public JitControlFlowModel(JitAnalysisContext context) {
        this.passage = context.getPassage();
        this.blocks = this.analyze();
    }

    protected SequencedMap<PcodeOp, JitBlock> analyze() {
        BlockSplitter splitter = new BlockSplitter(this, this.passage){

            @Override
            protected JitPassage.IntBranch newFallthroughIntBranch(PcodeOp from, PcodeOp to) {
                return new JitPassage.RIntBranch(from, to, true, JitPassage.Reachability.WITHOUT_CTXMOD);
            }
        };
        splitter.addBranches(this.passage.getBranches().values());
        return splitter.splitBlocks();
    }

    public Collection<JitBlock> getBlocks() {
        return this.blocks.values();
    }

    public void dumpResult() {
        System.err.println("STAGE: ControlFlow");
        for (JitBlock block : this.blocks.values()) {
            System.err.println("");
            System.err.println("Block: " + String.valueOf(block));
            System.err.println("Branches to:");
            for (JitPassage.IntBranch intBranch : block.branchesTo) {
                System.err.println("  " + String.valueOf(intBranch));
            }
            System.err.println("Flows to:");
            for (BlockFlow blockFlow : block.flowsTo.values()) {
                System.err.println("  " + String.valueOf(blockFlow));
            }
            System.err.println(block.format(true));
            System.err.println("Branches from:");
            for (JitPassage.IntBranch intBranch : block.branchesFrom) {
                System.err.println("  " + String.valueOf(intBranch));
            }
            System.err.println("Flows from:");
            for (BlockFlow blockFlow : block.flowsFrom.values()) {
                System.err.println("  " + String.valueOf(blockFlow));
            }
            System.err.println("Branches out:");
            for (JitPassage.Branch branch : block.branchesOut) {
                System.err.println("  " + String.valueOf(branch));
            }
        }
    }

    public static abstract class BlockSplitter {
        private final PcodeProgram program;
        private final Map<PcodeOp, JitPassage.Branch> branches = new HashMap<PcodeOp, JitPassage.Branch>();
        private final Map<PcodeOp, JitPassage.IntBranch> branchesByTarget = new HashMap<PcodeOp, JitPassage.IntBranch>();
        private final SequencedMap<PcodeOp, JitBlock> blocks = new LinkedHashMap<PcodeOp, JitBlock>();
        private List<PcodeOp> partialBlock = new ArrayList<PcodeOp>();
        private JitBlock lastBlock = null;

        public BlockSplitter(PcodeProgram program) {
            this.program = program;
        }

        protected abstract JitPassage.IntBranch newFallthroughIntBranch(PcodeOp var1, PcodeOp var2);

        public void addBranches(Collection<? extends JitPassage.Branch> branches) {
            for (JitPassage.Branch branch : branches) {
                this.branches.put(branch.from(), branch);
                if (!(branch instanceof JitPassage.IntBranch)) continue;
                JitPassage.IntBranch ib = (JitPassage.IntBranch)branch;
                this.branchesByTarget.put(ib.to(), ib);
            }
        }

        private JitBlock makeBlock() {
            if (!this.partialBlock.isEmpty()) {
                this.lastBlock = new JitBlock(this.program, this.partialBlock);
                this.partialBlock = new ArrayList<PcodeOp>();
                this.blocks.put(this.lastBlock.first(), this.lastBlock);
                return this.lastBlock;
            }
            return null;
        }

        private boolean needsFallthrough(JitBlock block) {
            if (block.branchesFrom.isEmpty() && block.branchesOut.isEmpty()) {
                return true;
            }
            if (block.branchesFrom.size() == 1) {
                return JitPassage.hasFallthrough(block.branchesFrom.getFirst().from());
            }
            if (block.branchesOut.size() == 1) {
                return JitPassage.hasFallthrough(block.branchesOut.getFirst().from());
            }
            throw new AssertionError();
        }

        private void checkForFallthrough(PcodeOp op) {
            if (this.lastBlock == null) {
                return;
            }
            if (this.needsFallthrough(this.lastBlock)) {
                this.lastBlock.branchesFrom.add(this.newFallthroughIntBranch(this.lastBlock.getCode().getLast(), op));
            }
            this.lastBlock = null;
        }

        private void fillFlows() {
            for (JitBlock from : this.blocks.values()) {
                for (JitPassage.Branch branch : from.branchesFrom) {
                    if (!(branch instanceof JitPassage.IntBranch)) continue;
                    JitPassage.IntBranch ib = (JitPassage.IntBranch)branch;
                    JitBlock to = Objects.requireNonNull((JitBlock)this.blocks.get(ib.to()));
                    to.branchesTo.add(ib);
                    BlockFlow flow = new BlockFlow(from, to, ib);
                    from.flowsFrom.put(ib, flow);
                    to.flowsTo.put(ib, flow);
                }
            }
        }

        private void cook() {
            for (JitBlock block : this.blocks.values()) {
                block.cook();
            }
        }

        private JitPassage.IntBranch getBranchTo(PcodeOp to) {
            return this.branchesByTarget.get(to);
        }

        private JitPassage.Branch getBranchFrom(PcodeOp from) {
            return this.branches.get(from);
        }

        private void doWork() {
            if (this.program.getCode().isEmpty()) {
                throw new IllegalArgumentException("No code to analyze");
            }
            for (PcodeOp op : this.program.getCode()) {
                this.checkForFallthrough(op);
                JitPassage.IntBranch branchTo = this.getBranchTo(op);
                if (branchTo != null) {
                    this.makeBlock();
                    this.checkForFallthrough(op);
                }
                this.partialBlock.add(op);
                JitPassage.Branch branchFrom = this.getBranchFrom(op);
                if (branchFrom == null) continue;
                this.makeBlock();
                if (branchFrom instanceof JitPassage.IntBranch) {
                    JitPassage.IntBranch ib = (JitPassage.IntBranch)branchFrom;
                    this.lastBlock.branchesFrom.add(ib);
                    continue;
                }
                this.lastBlock.branchesOut.add(branchFrom);
            }
            this.makeBlock();
            if (this.needsFallthrough(this.lastBlock)) {
                throw new UnterminatedFlowException();
            }
            this.fillFlows();
            this.cook();
        }

        private SequencedMap<PcodeOp, JitBlock> getBlocks() {
            return this.blocks;
        }

        public SequencedMap<PcodeOp, JitBlock> splitBlocks() {
            this.doWork();
            return this.getBlocks();
        }
    }

    public static class JitBlock
    extends PcodeProgram {
        private Map<JitPassage.IntBranch, BlockFlow> flowsFrom = new HashMap<JitPassage.IntBranch, BlockFlow>();
        private Map<JitPassage.IntBranch, BlockFlow> flowsTo = new HashMap<JitPassage.IntBranch, BlockFlow>();
        private List<JitPassage.IntBranch> branchesFrom = new ArrayList<JitPassage.IntBranch>();
        private List<JitPassage.IntBranch> branchesTo = new ArrayList<JitPassage.IntBranch>();
        private List<JitPassage.Branch> branchesOut = new ArrayList<JitPassage.Branch>();
        private final int instructions;
        private final int trailingOps;

        public JitBlock(PcodeProgram program, List<PcodeOp> code) {
            super(program, List.copyOf(code));
            int instructions = 0;
            int trailingOps = 0;
            for (PcodeOp op : code) {
                JitPassage.DecodedPcodeOp dec;
                if (op instanceof JitPassage.DecodedPcodeOp && (dec = (JitPassage.DecodedPcodeOp)op).isInstructionStart()) {
                    ++instructions;
                    trailingOps = 0;
                    continue;
                }
                if (!(op instanceof JitPassage.DecodedPcodeOp)) continue;
                ++trailingOps;
            }
            this.instructions = instructions;
            this.trailingOps = trailingOps;
        }

        @Override
        protected String getHead() {
            return super.getHead() + "[start=" + String.valueOf(this.start()) + "]";
        }

        @Override
        public String toString() {
            return this.getHead();
        }

        public PcodeOp first() {
            return (PcodeOp)this.code.getFirst();
        }

        public SequenceNumber start() {
            return ((PcodeOp)this.code.getFirst()).getSeqnum();
        }

        public SequenceNumber end() {
            return ((PcodeOp)this.code.getLast()).getSeqnum();
        }

        private void cook() {
            this.flowsFrom = Collections.unmodifiableMap(this.flowsFrom);
            this.flowsTo = Collections.unmodifiableMap(this.flowsTo);
            this.branchesFrom = Collections.unmodifiableList(this.branchesFrom);
            this.branchesTo = Collections.unmodifiableList(this.branchesTo);
            this.branchesOut = Collections.unmodifiableList(this.branchesOut);
        }

        public Map<JitPassage.IntBranch, BlockFlow> flowsFrom() {
            return this.flowsFrom;
        }

        public Map<JitPassage.IntBranch, BlockFlow> flowsTo() {
            return this.flowsTo;
        }

        public List<JitPassage.IntBranch> branchesFrom() {
            return this.branchesFrom;
        }

        public List<JitPassage.IntBranch> branchesTo() {
            return this.branchesTo;
        }

        public List<JitPassage.Branch> branchesOut() {
            return this.branchesOut;
        }

        public JitBlock getFallFrom() {
            return this.flowsFrom.values().stream().filter(f -> f.branch.isFall()).findAny().map(f -> f.to).orElse(null);
        }

        public boolean hasJumpTo() {
            return this.flowsTo.values().stream().anyMatch(f -> !f.branch.isFall());
        }

        public JitBlock getTargetBlock(JitPassage.IntBranch branch) {
            return this.flowsFrom.get((Object)branch).to;
        }

        public int instructionCount() {
            return this.instructions;
        }

        public int trailingOpCount() {
            return this.trailingOps;
        }
    }

    public record BlockFlow(JitBlock from, JitBlock to, JitPassage.IntBranch branch) {
        public static BlockFlow entry(JitBlock to) {
            return new BlockFlow(null, to, null);
        }
    }

    public static class UnterminatedFlowException
    extends IllegalArgumentException {
        public UnterminatedFlowException() {
            super("Final block cannot fall through");
        }
    }
}

