/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.pdb.pdbapplicator;

import ghidra.app.util.bin.format.pdb2.pdbreader.MsSymbolIterator;
import ghidra.app.util.bin.format.pdb2.pdbreader.PdbException;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractDefinedSingleAddressRangeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractLocalSymbolInOptimizedCodeMsSymbol;
import ghidra.app.util.bin.format.pdb2.pdbreader.symbol.AbstractMsSymbol;
import ghidra.app.util.pdb.pdbapplicator.DefaultPdbApplicator;
import ghidra.app.util.pdb.pdbapplicator.DefinedSingleAddressRangeSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.FunctionSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.MsSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestableSymbolApplier;
import ghidra.app.util.pdb.pdbapplicator.NestingSymbolApplier;
import ghidra.util.exception.AssertException;
import ghidra.util.exception.CancelledException;

public class LocalOptimizedSymbolApplier
extends MsSymbolApplier
implements NestingSymbolApplier,
NestableSymbolApplier {
    private AbstractLocalSymbolInOptimizedCodeMsSymbol symbol;

    public LocalOptimizedSymbolApplier(DefaultPdbApplicator applicator, AbstractLocalSymbolInOptimizedCodeMsSymbol symbol) {
        super(applicator);
        this.symbol = symbol;
    }

    @Override
    public void applyTo(NestingSymbolApplier applyToApplier, MsSymbolIterator iter) throws PdbException, CancelledException {
        this.getValidatedSymbol(iter, true);
        if (!this.applicator.getPdbApplicatorOptions().applyFunctionVariables()) {
            return;
        }
        if (applyToApplier instanceof FunctionSymbolApplier) {
            FunctionSymbolApplier functionSymbolApplier = (FunctionSymbolApplier)applyToApplier;
            this.doWork(functionSymbolApplier, iter);
        }
    }

    private void doWork(FunctionSymbolApplier functionSymbolApplier, MsSymbolIterator iter) throws CancelledException, PdbException {
        AbstractMsSymbol abstractMsSymbol;
        this.symbol.getLocalVariableFlags();
        this.symbol.getName();
        this.symbol.getTypeRecordNumber();
        while (iter.hasNext() && (abstractMsSymbol = iter.peek()) instanceof AbstractDefinedSingleAddressRangeMsSymbol) {
            AbstractDefinedSingleAddressRangeMsSymbol subSymbol = (AbstractDefinedSingleAddressRangeMsSymbol)abstractMsSymbol;
            this.applicator.checkCancelled();
            MsSymbolApplier applier = this.applicator.getSymbolApplier(subSymbol, iter);
            if (!(applier instanceof DefinedSingleAddressRangeSymbolApplier)) {
                throw new PdbException("Expected Range Applier not encountered");
            }
            DefinedSingleAddressRangeSymbolApplier rangeApplier = (DefinedSingleAddressRangeSymbolApplier)applier;
            rangeApplier.applyTo(this, iter);
        }
    }

    private AbstractLocalSymbolInOptimizedCodeMsSymbol getValidatedSymbol(MsSymbolIterator iter, boolean iterate) {
        AbstractMsSymbol abstractSymbol;
        AbstractMsSymbol abstractMsSymbol = abstractSymbol = iterate ? iter.next() : iter.peek();
        if (!(abstractSymbol instanceof AbstractLocalSymbolInOptimizedCodeMsSymbol)) {
            throw new AssertException("Invalid symbol type: " + abstractSymbol.getClass().getSimpleName());
        }
        AbstractLocalSymbolInOptimizedCodeMsSymbol localSymbol = (AbstractLocalSymbolInOptimizedCodeMsSymbol)abstractSymbol;
        return localSymbol;
    }
}

