/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.generic;

import ghidra.app.plugin.processors.generic.BinaryExpression;
import ghidra.app.plugin.processors.generic.ConstructorInfo;
import ghidra.app.plugin.processors.generic.Handle;
import ghidra.app.plugin.processors.generic.Offset;
import ghidra.app.plugin.processors.generic.OperandValue;
import ghidra.app.plugin.processors.generic.Position;
import ghidra.program.model.mem.MemBuffer;
import ghidra.program.model.pcode.PcodeOp;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Hashtable;

public class Operand
implements Serializable {
    private boolean dynamic;
    private String name;
    private OperandValue op;
    private Offset offset;
    private Handle handle;

    public Operand(String n, OperandValue o, Offset off) {
        this.name = n;
        this.op = o;
        this.offset = off;
    }

    public String toString(MemBuffer buf, int off) throws Exception {
        return this.op.toString(buf, this.offset.getOffset(buf, off));
    }

    public int length(MemBuffer buf, int off) throws Exception {
        int o = this.offset.getOffset(buf, off);
        return this.op.length(buf, o) + o - off;
    }

    public ConstructorInfo getInfo(MemBuffer buf, int off) throws Exception {
        int o = this.offset.getOffset(buf, off);
        ConstructorInfo opinfo = this.op.getInfo(buf, o);
        opinfo.addLength(o - off);
        return opinfo;
    }

    public String name() {
        return this.name;
    }

    public void linkRelativeOffsets(Hashtable<String, Operand> opHash) {
        if (this.op.getClass() == BinaryExpression.class) {
            ((BinaryExpression)this.op).linkRelativeOffsets(opHash);
        } else {
            this.offset.setRelativeOffset(opHash);
        }
    }

    public Handle getHandle(ArrayList<PcodeOp> pcode, Position position, int off) throws Exception {
        this.handle = this.op.getHandle(pcode, position, this.offset.getOffset(position.buffer(), off));
        this.testDynamic();
        return this.handle;
    }

    public Handle getHandle() {
        return this.handle;
    }

    public Handle getHandle(Position position, int off) throws Exception {
        return this.op.getHandle(position, this.offset.getOffset(position.buffer(), off));
    }

    public void getAllHandles(ArrayList<Handle> handles, Position position, int off) throws Exception {
        this.op.getAllHandles(handles, position, this.offset.getOffset(position.buffer(), off));
    }

    public PcodeOp[] getPcode(Position position) throws Exception {
        ArrayList<PcodeOp> pcode = new ArrayList<PcodeOp>();
        this.getHandle(pcode, position, 0);
        PcodeOp[] pcodeops = new PcodeOp[pcode.size()];
        pcode.toArray(pcodeops);
        return pcodeops;
    }

    public boolean dynamic() {
        return this.dynamic;
    }

    private void testDynamic() {
        this.dynamic = this.handle != null ? this.handle.dynamic() : false;
    }

    public void toList(ArrayList<Handle> list, Position position, int off) throws Exception {
        this.op.toList(list, position, this.offset.getOffset(position.buffer(), off));
    }

    public int getSize() {
        return this.op.getSize();
    }
}

