/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util;

public class JavaSourceLine {
    private int lineNumber;
    private String lineText;
    private String originalText;
    private boolean isDeleted;

    public JavaSourceLine(String line, int lineNumber) {
        this.lineText = line;
        this.originalText = line;
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void delete() {
        this.lineText = "";
        this.isDeleted = true;
    }

    public String getLeadingWhitespace() {
        char charAt;
        int length = this.lineText.length();
        if (length == 0) {
            return "";
        }
        StringBuffer buffy = new StringBuffer();
        for (int i = 0; i < length && Character.isWhitespace(charAt = this.lineText.charAt(i)); ++i) {
            buffy.append(charAt);
        }
        return buffy.toString();
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public String getText() {
        return this.lineText;
    }

    public void prepend(String text) {
        this.lineText = text + this.lineText;
        this.isDeleted = false;
    }

    public void append(String text) {
        this.lineText = this.lineText + text;
        this.isDeleted = false;
    }

    public void setText(String text) {
        this.lineText = text;
        this.isDeleted = false;
    }

    public boolean hasChanges() {
        return !this.originalText.equals(this.lineText);
    }

    public String toString() {
        return this.lineText;
    }

    JavaSourceLine createOriginalClone() {
        return new JavaSourceLine(this.originalText, this.lineNumber);
    }

    public String getOriginalText() {
        return this.originalText;
    }
}

