/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.datamgr.util;

import docking.widgets.OptionDialog;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeState;
import ghidra.app.plugin.core.datamgr.archive.Archive;
import ghidra.app.plugin.core.datamgr.archive.ProgramArchive;
import ghidra.app.plugin.core.datamgr.tree.ArchiveNode;
import ghidra.app.plugin.core.datamgr.tree.CategoryNode;
import ghidra.app.plugin.core.datamgr.tree.DataTypeArchiveGTree;
import ghidra.app.plugin.core.datamgr.tree.DataTypeNode;
import ghidra.program.model.data.Array;
import ghidra.program.model.data.BuiltInDataType;
import ghidra.program.model.data.Category;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.DataTypeConflictHandler;
import ghidra.program.model.data.DataTypeDependencyException;
import ghidra.program.model.data.DataTypeManager;
import ghidra.program.model.data.MissingBuiltInDataType;
import ghidra.program.model.data.Pointer;
import ghidra.program.model.data.SourceArchive;
import ghidra.util.InvalidNameException;
import ghidra.util.Msg;
import ghidra.util.UniversalID;
import ghidra.util.exception.CancelledException;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.Task;
import ghidra.util.task.TaskMonitor;
import java.awt.Component;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class DataTypeTreeCopyMoveTask
extends Task {
    private static final int NODE_COUNT_FOR_COLLAPSING_TREE = 100;
    private DataTypeArchiveGTree gTree;
    private Category destinationCategory;
    private List<GTreeNode> copyMoveNodes;
    private Archive sourceArchive;
    private Archive destinationArchive;
    private boolean promptToAssociateTypes = true;
    private ActionType actionType;
    private DataTypeConflictHandler conflictHandler;
    private List<String> errors = new ArrayList<String>();

    DataTypeTreeCopyMoveTask() {
        super("Drag/Drop", true, true, true);
    }

    public DataTypeTreeCopyMoveTask(CategoryNode destinationNode, List<GTreeNode> droppedNodeList, ActionType actionType, DataTypeArchiveGTree gTree, DataTypeConflictHandler conflictHandler) {
        this(DataTypeTreeCopyMoveTask.findArchive((GTreeNode)destinationNode), destinationNode.getCategory(), droppedNodeList, actionType, gTree, conflictHandler);
    }

    public DataTypeTreeCopyMoveTask(Archive destinationArchive, Category destinationCategory, List<GTreeNode> droppedNodeList, ActionType actionType, DataTypeArchiveGTree gTree, DataTypeConflictHandler conflictHandler) {
        super("Drag/Drop", true, true, true);
        this.destinationCategory = destinationCategory;
        this.copyMoveNodes = droppedNodeList;
        this.actionType = actionType;
        this.gTree = gTree;
        this.conflictHandler = conflictHandler;
        this.destinationArchive = destinationArchive;
        GTreeNode firstNode = this.copyMoveNodes.get(0);
        this.sourceArchive = DataTypeTreeCopyMoveTask.findArchive(firstNode);
    }

    private static Archive findArchive(GTreeNode node) {
        while (node != null) {
            if (node instanceof ArchiveNode) {
                return ((ArchiveNode)node).getArchive();
            }
            node = node.getParent();
        }
        return null;
    }

    public void setPromptToAssociateTypes(boolean prompt) {
        this.promptToAssociateTypes = prompt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(TaskMonitor monitor) throws CancelledException {
        int nodeCount = this.copyMoveNodes.size();
        this.filterRedundantNodes();
        if (this.checkForDifferentSourceArchives()) {
            return;
        }
        GTreeState treeState = this.gTree.getTreeState();
        try {
            if (nodeCount > 100) {
                this.collapseArchives();
            }
            if (this.needToCreateAssociation()) {
                this.associateDataTypes(monitor);
            }
            this.doCopy(monitor);
        }
        catch (CancelledException e) {
            return;
        }
        finally {
            this.gTree.restoreTreeState(treeState);
        }
        this.reportErrors();
    }

    private void reportErrors() {
        if (this.errors.isEmpty()) {
            return;
        }
        Object message = this.errors.get(0);
        int n = this.errors.size();
        if (n > 1) {
            message = "Encountered " + n + " errors copying/moving.  See the log for details";
        }
        Msg.showError((Object)((Object)this), (Component)((Object)this.gTree), (String)"Encountered Errors Copying/Moving", (Object)message);
    }

    private boolean checkForDifferentSourceArchives() {
        for (GTreeNode node : this.copyMoveNodes) {
            if (this.sourceArchive == DataTypeTreeCopyMoveTask.findArchive(node)) continue;
            Msg.showError((Object)((Object)this), (Component)((Object)this.gTree), (String)"Copy Failed", (Object)"All data types must be from the same archive!");
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCopy(TaskMonitor monitor) {
        DataTypeManager dtm = this.destinationArchive.getDataTypeManager();
        int txId = dtm.startTransaction("Copy/Move Category/DataType");
        try {
            this.copyOrMoveNodesToCategory(monitor);
        }
        finally {
            dtm.endTransaction(txId, true);
        }
    }

    private boolean needToCreateAssociation() {
        return this.sourceArchive != this.destinationArchive && !(this.destinationArchive instanceof ProgramArchive) && this.sourceArchive instanceof ProgramArchive;
    }

    private void collapseArchives() {
        GTreeNode root = this.gTree.getModelRoot();
        List children = root.getChildren();
        for (GTreeNode archive : children) {
            this.gTree.collapseAll(archive);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void associateDataTypes(TaskMonitor monitor) throws CancelledException {
        if (!this.promptToAssociateTypes(monitor)) {
            return;
        }
        monitor.initialize((long)this.copyMoveNodes.size());
        SourceArchive destination = this.destinationArchive.getDataTypeManager().getLocalSourceArchive();
        DataTypeManager dtm = this.sourceArchive.getDataTypeManager();
        int txId = dtm.startTransaction("Associate Data Types");
        try {
            for (GTreeNode node : this.copyMoveNodes) {
                monitor.checkCancelled();
                if (node instanceof DataTypeNode) {
                    DataType dt = ((DataTypeNode)node).getDataType();
                    this.associateDataType(dt, dtm, destination);
                } else if (node instanceof CategoryNode) {
                    Category cat = ((CategoryNode)node).getCategory();
                    this.associateDataTypes(cat, dtm, destination);
                }
                monitor.incrementProgress(1L);
            }
        }
        finally {
            dtm.endTransaction(txId, true);
        }
    }

    private boolean promptToAssociateTypes(TaskMonitor monitor) throws CancelledException {
        if (!this.promptToAssociateTypes) {
            return true;
        }
        if (!this.containsUnassociatedTypes(monitor)) {
            return false;
        }
        int result = this.askToAssociateDataTypes();
        if (result == 0) {
            throw new CancelledException();
        }
        return result == 1;
    }

    private boolean containsUnassociatedTypes(TaskMonitor monitor) throws CancelledException {
        monitor.setMessage("Checking for types to associate");
        monitor.initialize((long)this.copyMoveNodes.size());
        for (GTreeNode node : this.copyMoveNodes) {
            DataType dt;
            monitor.checkCancelled();
            if (node instanceof DataTypeNode ? this.isLocal(dt = ((DataTypeNode)node).getDataType()) : node instanceof CategoryNode && this.containsUnassociatedTypes(((CategoryNode)node).getCategory(), monitor)) {
                return true;
            }
            monitor.incrementProgress(1L);
        }
        return false;
    }

    private boolean containsUnassociatedTypes(Category cat, TaskMonitor monitor) throws CancelledException {
        Category[] categories;
        DataType[] types;
        for (DataType dt : types = cat.getDataTypes()) {
            monitor.checkCancelled();
            if (!this.isLocal(dt)) continue;
            return true;
        }
        for (Category child : categories = cat.getCategories()) {
            monitor.checkCancelled();
            if (!this.containsUnassociatedTypes(child, monitor)) continue;
            return true;
        }
        return false;
    }

    private void associateDataType(DataType dt, DataTypeManager dtm, SourceArchive source) {
        if (!this.isLocal(dt)) {
            return;
        }
        dtm.associateDataTypeWithArchive(dt, source);
    }

    private void associateDataTypes(Category cat, DataTypeManager dtm, SourceArchive destination) {
        Category[] categories;
        DataType[] dataTypes;
        for (DataType dataType : dataTypes = cat.getDataTypes()) {
            this.associateDataType(dataType, dtm, destination);
        }
        for (Category category : categories = cat.getCategories()) {
            this.associateDataTypes(category, dtm, destination);
        }
    }

    private void copyOrMoveNodesToCategory(TaskMonitor monitor) {
        monitor.setMessage("Drag/Drop Categories/Data Types");
        monitor.initialize((long)this.copyMoveNodes.size());
        Category toCategory = this.destinationCategory;
        for (GTreeNode node : this.copyMoveNodes) {
            if (monitor.isCancelled()) break;
            monitor.setMessage("Adding " + node.getName());
            if (this.actionType == ActionType.COPY || this.sourceArchive != this.destinationArchive) {
                this.copyNode(toCategory, node, monitor);
            } else {
                this.moveNode(toCategory, node, monitor);
            }
            monitor.incrementProgress(1L);
        }
    }

    private void copyNode(Category toCategory, GTreeNode node, TaskMonitor monitor) {
        if (node instanceof DataTypeNode) {
            DataType nodeDt = ((DataTypeNode)node).getDataType();
            this.copyDataType(toCategory, nodeDt);
        } else if (node instanceof CategoryNode) {
            Category category = ((CategoryNode)node).getCategory();
            this.copyCategory(toCategory, category, monitor);
        }
    }

    private void copyDataType(Category toCategory, DataType dataType) {
        DataType resolvedDt;
        DataType newDt;
        DataTypeManager nodeDtm;
        DataTypeManager dtm = toCategory.getDataTypeManager();
        boolean sameManager = dtm == (nodeDtm = dataType.getDataTypeManager());
        DataType dataType2 = newDt = !sameManager ? dataType.clone(nodeDtm) : dataType.copy(nodeDtm);
        if (!sameManager && toCategory.isRoot()) {
            toCategory = dtm.createCategory(dataType.getCategoryPath());
        }
        if (sameManager && newDt.getCategoryPath().equals((Object)toCategory.getCategoryPath())) {
            this.renameAsCopy(toCategory, newDt);
        }
        if ((resolvedDt = toCategory.addDataType(newDt, this.conflictHandler)) instanceof Pointer || resolvedDt instanceof Array || resolvedDt instanceof BuiltInDataType || resolvedDt instanceof MissingBuiltInDataType) {
            return;
        }
        if (!resolvedDt.getCategoryPath().equals((Object)toCategory.getCategoryPath())) {
            this.errors.add("Data type copy failed.  Another copy of this data type already exists at " + resolvedDt.getPathName());
        }
    }

    private void renameAsCopy(Category toCategory, DataType dataType) {
        String dtName = dataType.getName();
        String baseName = this.getBaseName(dtName);
        String copyName = this.getNextCopyName(toCategory, baseName);
        try {
            dataType.setName(copyName);
        }
        catch (InvalidNameException | DuplicateNameException e) {
            this.errors.add("Problem creating copy of " + baseName + ". " + e.getMessage());
        }
    }

    String getBaseName(String dtName) {
        Pattern p = Pattern.compile("Copy_(?:\\d+_)*of_(.*)");
        Matcher matcher = p.matcher(dtName);
        if (!matcher.matches()) {
            return dtName;
        }
        String baseName = matcher.group(1);
        return baseName;
    }

    String getNextCopyName(Category toCategory, String baseName) {
        String format = "Copy_%d_of_" + baseName;
        for (int i = 1; i < 100; ++i) {
            String copyName = String.format(format, i);
            if (toCategory.getDataType(copyName) != null) continue;
            return copyName;
        }
        return String.format(format, System.currentTimeMillis());
    }

    private void moveNode(Category toCategory, GTreeNode node, TaskMonitor monitor) {
        if (node instanceof DataTypeNode) {
            DataType dataType = ((DataTypeNode)node).getDataType();
            this.moveDataType(toCategory, dataType);
        } else if (node instanceof CategoryNode) {
            Category category = ((CategoryNode)node).getCategory();
            this.moveCategory(toCategory, category, monitor);
        }
    }

    private void moveCategory(Category toCategory, Category category, TaskMonitor monitor) {
        if (category.getParent() == toCategory) {
            return;
        }
        try {
            CategoryPath path = toCategory.getCategoryPath();
            if (path.isAncestorOrSelf(category.getCategoryPath())) {
                this.errors.add("Cannot move a parent node onto a child node.  Moving " + String.valueOf(category) + " to " + String.valueOf(toCategory));
                return;
            }
            toCategory.moveCategory(category, monitor);
        }
        catch (DuplicateNameException e) {
            this.errors.add("Move failed due to duplicate name.   Moving " + String.valueOf(category) + " to " + String.valueOf(toCategory) + ": " + e.getMessage());
        }
    }

    private void moveDataType(Category toCategory, DataType dataType) {
        if (dataType.getCategoryPath().equals((Object)toCategory.getCategoryPath())) {
            this.errors.add("Move failed.  DataType is already in this category.  Category " + String.valueOf(toCategory) + "; Data type: " + dataType.getName());
            return;
        }
        try {
            toCategory.moveDataType(dataType, this.conflictHandler);
        }
        catch (DataTypeDependencyException e) {
            this.errors.add("Move failed.  DataType is already in this category.  Category " + String.valueOf(toCategory) + "; Data type: " + dataType.getName() + ". " + e.getMessage());
        }
    }

    private void copyCategory(Category toCategory, Category category, TaskMonitor monitor) {
        boolean sameManager;
        CategoryPath toPath = toCategory.getCategoryPath();
        boolean bl = sameManager = toCategory.getDataTypeManager() == category.getDataTypeManager();
        if (sameManager && toPath.isAncestorOrSelf(category.getCategoryPath())) {
            this.errors.add("Copy failed.  Cannot copy a parent node onto a child node. Moving " + String.valueOf(category) + " to " + String.valueOf(toCategory));
            return;
        }
        toCategory.copyCategory(category, this.conflictHandler, monitor);
    }

    private boolean isLocal(DataType dt) {
        UniversalID sourceId = dt.getSourceArchive().getSourceArchiveID();
        UniversalID dtmId = dt.getDataTypeManager().getUniversalID();
        return sourceId.equals((Object)dtmId);
    }

    private int askToAssociateDataTypes() {
        return OptionDialog.showYesNoCancelDialog((Component)((Object)this.gTree), (String)"Associate Data Types?", (String)"Do you want to associate local data types with the target archive?");
    }

    private void filterRedundantNodes() {
        HashSet<GTreeNode> nodeSet = new HashSet<GTreeNode>(this.copyMoveNodes);
        ArrayList<GTreeNode> filteredList = new ArrayList<GTreeNode>();
        for (GTreeNode node : nodeSet) {
            if (this.containsAncestor(nodeSet, node)) continue;
            filteredList.add(node);
        }
        this.copyMoveNodes = filteredList;
    }

    private boolean containsAncestor(Set<GTreeNode> nodeSet, GTreeNode node) {
        GTreeNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        if (nodeSet.contains(parent)) {
            return true;
        }
        return this.containsAncestor(nodeSet, parent);
    }

    public static enum ActionType {
        COPY,
        MOVE;

    }
}

