/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.function;

import ghidra.app.plugin.core.function.FunctionAnalyzer;
import ghidra.app.services.AnalysisPriority;
import ghidra.app.util.importer.MessageLog;
import ghidra.framework.options.Options;
import ghidra.program.model.address.AddressSetView;
import ghidra.program.model.listing.Program;
import ghidra.util.HelpLocation;
import ghidra.util.task.TaskMonitor;

public class CreateThunkAnalyzer
extends FunctionAnalyzer {
    private static final String FIND_THUNKS_STARTS_MSG = "Create Thunks : ";
    private static final String OPTION_NAME_CREATE_THUNKS_EARLY = "Create Thunks Early";
    private static final String OPTION_DESCRIPTION_CREATE_THUNKS_EARLY = "If checked, create thunk functions early in analysis flow.";
    private static final boolean OPTION_DEFAULT_CREATE_THUNKS_EARLY_ENABLED = true;

    public CreateThunkAnalyzer() {
        this.setPriority(AnalysisPriority.BLOCK_ANALYSIS.after().after());
        this.setDefaultEnablement(true);
        this.createOnlyThunks = true;
        this.analysisMessage = FIND_THUNKS_STARTS_MSG;
    }

    @Override
    public boolean added(Program program, AddressSetView set, TaskMonitor monitor, MessageLog log) {
        if (!this.createOnlyThunks) {
            return true;
        }
        return super.added(program, set, monitor, log);
    }

    @Override
    public void registerOptions(Options options, Program prog) {
        HelpLocation helpLocation = new HelpLocation("AutoAnalysisPlugin", "Auto_Analysis_Option_Instruction" + String.valueOf((Object)this.getAnalysisType()));
        options.registerOption(OPTION_NAME_CREATE_THUNKS_EARLY, (Object)this.createOnlyThunks, null, OPTION_DESCRIPTION_CREATE_THUNKS_EARLY);
    }

    @Override
    public void optionsChanged(Options options, Program prog) {
        this.createOnlyThunks = options.getBoolean(OPTION_NAME_CREATE_THUNKS_EARLY, this.createOnlyThunks);
    }
}

