/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.macho.commands;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.format.macho.MachHeader;
import ghidra.app.util.bin.format.macho.commands.DynamicLibrary;
import ghidra.app.util.bin.format.macho.commands.LoadCommand;
import ghidra.app.util.bin.format.macho.commands.LoadCommandString;
import ghidra.app.util.importer.MessageLog;
import ghidra.program.flatapi.FlatProgramAPI;
import ghidra.program.model.address.Address;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.program.model.listing.ProgramModule;
import ghidra.util.exception.DuplicateNameException;
import ghidra.util.task.TaskMonitor;
import java.io.IOException;

public class DynamicLibraryCommand
extends LoadCommand {
    private DynamicLibrary dylib;

    public DynamicLibraryCommand(BinaryReader reader) throws IOException {
        super(reader);
        this.dylib = new DynamicLibrary(reader, this);
    }

    public DynamicLibrary getDynamicLibrary() {
        return this.dylib;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(this.getCommandName(), 0);
        struct.add(DWORD, "cmd", null);
        struct.add(DWORD, "cmdsize", null);
        struct.add(this.dylib.toDataType(), "dylib", null);
        struct.setCategoryPath(new CategoryPath("/MachO"));
        return struct;
    }

    @Override
    public String getCommandName() {
        return "dylib_command";
    }

    @Override
    public void markupRawBinary(MachHeader header, FlatProgramAPI api, Address baseAddress, ProgramModule parentModule, TaskMonitor monitor, MessageLog log) {
        try {
            super.markupRawBinary(header, api, baseAddress, parentModule, monitor, log);
            Address address = baseAddress.getNewAddress(this.getStartIndex());
            LoadCommandString name = this.dylib.getName();
            int length = this.getCommandSize() - name.getOffset();
            Address strAddr = address.add((long)name.getOffset());
            api.createAsciiString(strAddr, length);
        }
        catch (Exception e) {
            log.appendMsg("Unable to create " + this.getCommandName());
        }
    }

    public String toString() {
        return this.dylib.toString();
    }
}

