/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe;

import ghidra.app.util.bin.BinaryReader;
import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.Writeable;
import ghidra.app.util.bin.format.pe.RichTable;
import ghidra.app.util.bin.format.pe.rich.RichHeaderRecord;
import ghidra.program.model.data.DataType;
import ghidra.util.DataConverter;
import java.io.IOException;
import java.io.RandomAccessFile;

public class RichHeader
implements StructConverter,
Writeable {
    public static final int IMAGE_RICH_SIGNATURE = 1751345490;
    public static final int IMAGE_DANS_SIGNATURE = 1399742788;
    public static final String NAME = "IMAGE_RICH_HEADER";
    private BinaryReader reader;
    private RichTable table;

    public RichHeader(BinaryReader reader) {
        this.reader = reader;
        this.parse();
    }

    private void parse() {
        long currPos = this.reader.getPointerIndex();
        this.table = new RichTable(this.reader);
        if (this.table.getSize() == 0) {
            this.reader.setPointerIndex(currPos);
            return;
        }
        this.reader.setPointerIndex(this.table.getOffset() + (long)this.table.getSize());
    }

    public int getOffset() {
        return this.table == null ? -1 : (int)this.table.getOffset();
    }

    public int getSize() {
        return this.table == null ? 0 : this.table.getSize();
    }

    public int getMask() {
        return this.table == null ? -1 : this.table.getMask();
    }

    public RichHeaderRecord[] getRecords() {
        return this.table == null ? new RichHeaderRecord[]{} : this.table.getRecords();
    }

    @Override
    public DataType toDataType() {
        if (this.table.getSize() == 0) {
            return null;
        }
        return this.table.toDataType();
    }

    @Override
    public void write(RandomAccessFile raf, DataConverter dc) throws IOException {
        if (this.table != null) {
            raf.write(dc.getBytes(0x536E6144 ^ this.table.getMask()));
            raf.write(dc.getBytes(this.table.getMask()));
            raf.write(dc.getBytes(this.table.getMask()));
            raf.write(dc.getBytes(this.table.getMask()));
            for (RichHeaderRecord rec : this.table.getRecords()) {
                raf.write(dc.getBytes(rec.getCompId().getValue() ^ this.table.getMask()));
                raf.write(dc.getBytes(rec.getObjectCount() ^ this.table.getMask()));
            }
            raf.write(dc.getBytes(1751345490));
            raf.write(dc.getBytes(this.table.getMask()));
        }
    }
}

