/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.functiongraph.graph.jung.transformer;

import com.google.common.base.Function;
import edu.uci.ics.jung.visualization.picking.PickedInfo;
import generic.theme.Gui;
import ghidra.app.plugin.core.functiongraph.graph.FGVertexType;
import ghidra.app.plugin.core.functiongraph.graph.vertex.FGVertex;
import ghidra.program.util.ProgramSelection;
import ghidra.util.ColorUtils;
import java.awt.Color;
import java.awt.Paint;
import java.util.Objects;

public class FGVertexPickableBackgroundPaintTransformer
implements Function<FGVertex, Paint> {
    private final PickedInfo<FGVertex> info;
    private final Color pickedColor;
    private final Color entryColor;
    private final Color exitColor;
    private final Color pickedEntryColor;
    private final Color pickedExitColor;

    private static Color mix(Color c1, Color c2) {
        return ColorUtils.blend((Color)c1, (Color)c2, (double)0.5);
    }

    public FGVertexPickableBackgroundPaintTransformer(PickedInfo<FGVertex> info, Color pickedColor, Color startColor, Color endColor) {
        this.info = Objects.requireNonNull(info);
        this.pickedColor = pickedColor;
        this.entryColor = startColor;
        this.exitColor = endColor;
        this.pickedEntryColor = FGVertexPickableBackgroundPaintTransformer.mix(pickedColor, startColor);
        this.pickedExitColor = FGVertexPickableBackgroundPaintTransformer.mix(pickedColor, endColor);
    }

    public Paint apply(FGVertex v) {
        Color mixed;
        Color backgroundColor = v.getBackgroundColor();
        ProgramSelection selection = v.getProgramSelection();
        if (!selection.isEmpty()) {
            Color selectionColor = v.getSelectionColor();
            backgroundColor = mixed = FGVertexPickableBackgroundPaintTransformer.mix(selectionColor, backgroundColor);
        }
        FGVertexType vertexType = v.getVertexType();
        if (this.info.isPicked((Object)v)) {
            if (v.isDefaultBackgroundColor()) {
                if (vertexType.isEntry()) {
                    return this.pickedEntryColor;
                }
                if (vertexType.isExit()) {
                    return this.pickedExitColor;
                }
                return this.pickedColor;
            }
            if (vertexType.isEntry()) {
                return Gui.darker((Color)this.pickedEntryColor);
            }
            if (vertexType.isExit()) {
                return Gui.darker((Color)this.pickedExitColor);
            }
            mixed = FGVertexPickableBackgroundPaintTransformer.mix(this.pickedColor, backgroundColor);
            return Gui.darker((Color)mixed);
        }
        if (vertexType.isEntry()) {
            return this.entryColor;
        }
        if (vertexType.isExit()) {
            return this.exitColor;
        }
        return backgroundColor;
    }
}

