/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.component.external.model.ivy;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.internal.component.external.model.ivy.IvyComponentArtifactResolveMetadata;
import org.gradle.internal.component.external.model.ivy.IvyComponentGraphResolveState;
import org.gradle.internal.component.external.model.ivy.IvyModuleResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentIdGenerator;
import org.gradle.internal.component.model.ConfigurationGraphResolveState;
import org.gradle.internal.component.model.DefaultExternalModuleComponentGraphResolveState;
import org.gradle.internal.component.model.GraphSelectionCandidates;
import org.gradle.internal.component.model.ModuleConfigurationMetadata;
import org.gradle.internal.component.model.VariantGraphResolveState;
import org.jspecify.annotations.Nullable;

public class DefaultIvyComponentGraphResolveState
extends DefaultExternalModuleComponentGraphResolveState<IvyModuleResolveMetadata, IvyModuleResolveMetadata>
implements IvyComponentGraphResolveState {
    public DefaultIvyComponentGraphResolveState(long instanceId, IvyModuleResolveMetadata metadata, AttributeDesugaring attributeDesugaring, ComponentIdGenerator idGenerator) {
        super(instanceId, metadata, metadata, attributeDesugaring, idGenerator);
    }

    @Override
    public Set<String> getConfigurationNames() {
        return ((IvyModuleResolveMetadata)this.getMetadata()).getConfigurationNames();
    }

    @Override
    public @Nullable ConfigurationGraphResolveState getConfiguration(String configurationName) {
        ModuleConfigurationMetadata configuration = ((IvyModuleResolveMetadata)this.getMetadata()).getConfiguration(configurationName);
        if (configuration == null) {
            return null;
        }
        return this.resolveStateFor(configuration);
    }

    private @Nullable VariantGraphResolveState getConfigurationAsVariant(String name) {
        ConfigurationGraphResolveState configuration = this.getConfiguration(name);
        if (configuration == null) {
            return null;
        }
        return configuration.asVariant();
    }

    @Override
    public IvyComponentArtifactResolveMetadata getArtifactMetadata() {
        IvyModuleResolveMetadata legacyMetadata = (IvyModuleResolveMetadata)this.getLegacyMetadata();
        return new DefaultIvyComponentArtifactResolveMetadata(legacyMetadata);
    }

    @Override
    public IvyComponentGraphResolveState.IvyGraphSelectionCandidates getCandidatesForGraphVariantSelection() {
        return new DefaultIvyGraphSelectionCandidates(super.getCandidatesForGraphVariantSelection(), this::getConfigurationAsVariant);
    }

    private static class DefaultIvyComponentArtifactResolveMetadata
    extends DefaultExternalModuleComponentGraphResolveState.ExternalArtifactResolveMetadata
    implements IvyComponentArtifactResolveMetadata {
        private final IvyModuleResolveMetadata metadata;

        public DefaultIvyComponentArtifactResolveMetadata(IvyModuleResolveMetadata metadata) {
            super(metadata);
            this.metadata = metadata;
        }

        public @Nullable ImmutableList<? extends ComponentArtifactMetadata> getConfigurationArtifacts(String configurationName) {
            ModuleConfigurationMetadata configuration = this.metadata.getConfiguration(configurationName);
            if (configuration != null) {
                return configuration.getArtifacts();
            }
            return null;
        }
    }

    private static class DefaultIvyGraphSelectionCandidates
    implements IvyComponentGraphResolveState.IvyGraphSelectionCandidates {
        private final GraphSelectionCandidates candidates;
        private final Function<String, VariantGraphResolveState> configurationSupplier;

        public DefaultIvyGraphSelectionCandidates(GraphSelectionCandidates candidates, Function<String, VariantGraphResolveState> configurationSupplier) {
            this.candidates = candidates;
            this.configurationSupplier = configurationSupplier;
        }

        @Override
        public List<? extends VariantGraphResolveState> getVariantsForAttributeMatching() {
            return this.candidates.getVariantsForAttributeMatching();
        }

        @Override
        public @Nullable VariantGraphResolveState getLegacyVariant() {
            return this.getVariantByConfigurationName("default");
        }

        @Override
        public @Nullable VariantGraphResolveState getVariantByConfigurationName(String name) {
            return this.configurationSupplier.apply(name);
        }
    }
}

