/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.modca;

import java.io.UnsupportedEncodingException;
import org.apache.fop.afp.modca.AbstractTripletStructuredObject;

public abstract class AbstractNamedAFPObject
extends AbstractTripletStructuredObject {
    private static final int DEFAULT_NAME_LENGTH = 8;
    protected String name;

    protected AbstractNamedAFPObject() {
    }

    protected AbstractNamedAFPObject(String name) {
        this.name = name;
    }

    protected int getNameLength() {
        return 8;
    }

    public byte[] getNameBytes() {
        int afpNameLen = this.getNameLength();
        int nameLen = this.name.length();
        if (nameLen < afpNameLen) {
            this.name = (this.name + "       ").substring(0, afpNameLen);
        } else if (this.name.length() > afpNameLen) {
            String truncatedName = this.name.substring(nameLen - afpNameLen, nameLen);
            LOG.warn((Object)("Constructor:: name '" + this.name + "' truncated to " + afpNameLen + " chars ('" + truncatedName + "')"));
            this.name = truncatedName;
        }
        byte[] nameBytes = null;
        try {
            nameBytes = this.name.getBytes("Cp1146");
        }
        catch (UnsupportedEncodingException usee) {
            nameBytes = this.name.getBytes();
            LOG.warn((Object)("Constructor:: UnsupportedEncodingException translating the name " + this.name));
        }
        return nameBytes;
    }

    @Override
    protected void copySF(byte[] data, byte type, byte category) {
        super.copySF(data, type, category);
        byte[] nameData = this.getNameBytes();
        System.arraycopy(nameData, 0, data, 9, nameData.length);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String toString() {
        return this.getName();
    }
}

