/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.bookmarks.mindmapmode.ui;

import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import org.freeplane.features.bookmarks.mindmapmode.NodeBookmarkDescriptor;
import org.freeplane.features.filter.hidden.NodeVisibility;
import org.freeplane.features.icon.factory.IconStoreFactory;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

class BookmarkIconFactory {
    private static final Icon BOOKMARK_ROOT_ICON = IconStoreFactory.ICON_STORE.getUIIcon("bookmarkAsRoot.svg").getIcon();
    private static final Icon SELECTED_ROOT_ICON = IconStoreFactory.ICON_STORE.getUIIcon("currentRoot.svg").getIcon();
    private static final Icon SELECTED_SUBTREE_ICON = IconStoreFactory.ICON_STORE.getUIIcon("selectedSubtreeBookmark.svg").getIcon();
    private static final Icon HIDDEN_ICON = IconStoreFactory.ICON_STORE.getUIIcon("hidden.svg").getIcon();
    private static final Icon REMOVE_FILTER_ICON = IconStoreFactory.ICON_STORE.getUIIcon("bookmark-remove-filter.svg").getIcon();

    BookmarkIconFactory() {
    }

    static Icon createIcon(NodeModel node, NodeBookmarkDescriptor descriptor) {
        if (descriptor.opensAsRoot()) {
            return new RootBookmarkIcon(node);
        }
        return new SubtreeBookmarkIcon(node);
    }

    private static class RootBookmarkIcon
    implements Icon {
        private final NodeModel node;

        public RootBookmarkIcon(NodeModel node) {
            this.node = node;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Icon icon = Controller.getCurrentController().getSelection().getSelectionRoot() == this.node ? SELECTED_ROOT_ICON : BOOKMARK_ROOT_ICON;
            icon.paintIcon(c, g, x, y);
        }

        @Override
        public int getIconWidth() {
            return SELECTED_ROOT_ICON.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return SELECTED_ROOT_ICON.getIconHeight();
        }
    }

    private static class SubtreeBookmarkIcon
    implements Icon {
        private final NodeModel node;

        public SubtreeBookmarkIcon(NodeModel node) {
            this.node = node;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            boolean isBookmarkSubtreeSelected;
            if (NodeVisibility.isHidden((NodeModel)this.node)) {
                HIDDEN_ICON.paintIcon(c, g, x, y);
                return;
            }
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (!this.node.isVisible(selection.getFilter())) {
                REMOVE_FILTER_ICON.paintIcon(c, g, x, y);
                return;
            }
            NodeModel selected = selection.getSelected();
            boolean bl = isBookmarkSubtreeSelected = selected == this.node || selected.isDescendantOf(this.node);
            if (isBookmarkSubtreeSelected) {
                SELECTED_SUBTREE_ICON.paintIcon(c, g, x, y);
            }
        }

        @Override
        public int getIconWidth() {
            return SELECTED_SUBTREE_ICON.getIconWidth();
        }

        @Override
        public int getIconHeight() {
            return SELECTED_SUBTREE_ICON.getIconHeight();
        }
    }
}

