/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.export.mindmapmode;

import java.awt.image.RenderedImage;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.commons.lang.StringUtils;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.ui.CaseSensitiveFileNameExtensionFilter;
import org.freeplane.core.ui.components.UITools;
import org.freeplane.core.util.Compat;
import org.freeplane.core.util.FileUtils;
import org.freeplane.core.util.LogUtils;
import org.freeplane.core.util.TextUtils;
import org.freeplane.core.util.collection.SortedComboBoxModel;
import org.freeplane.features.export.mindmapmode.BranchXmlWriter;
import org.freeplane.features.export.mindmapmode.IExportEngine;
import org.freeplane.features.export.mindmapmode.ImageCreator;
import org.freeplane.features.icon.UIIcon;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.MapWriter;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;

public class ExportWithXSLT
implements IExportEngine {
    private static final Pattern propertyReferenceEpression = Pattern.compile("\\$\\{[^}]+\\}");
    private boolean mTransformResultWithoutError = false;
    private final Properties properties;
    private final String name;

    static void copyIconsToDirectory(MapModel map, String directoryName) {
        SortedComboBoxModel icons = map.getIconRegistry().getIconsAsListModel();
        for (int i = 0; i < icons.getSize(); ++i) {
            UIIcon icon = (UIIcon)icons.getElementAt(i);
            String iconName = icon.getName();
            StringBuilder sb = new StringBuilder(directoryName);
            int lastIndexOfSeparator = iconName.lastIndexOf(47);
            if (lastIndexOfSeparator != -1) {
                sb.append(File.separatorChar);
                sb.append(iconName.substring(0, lastIndexOfSeparator));
            }
            File destinationDirectory = new File(sb.toString());
            destinationDirectory.mkdirs();
            FileUtils.copyFromURL((URL)icon.getUrl(), (File)destinationDirectory);
        }
    }

    public ExportWithXSLT(String name, Properties properties) {
        this.name = name;
        this.properties = properties;
    }

    private void copyFilesFromResourcesToDirectory(String targetDirectoryName, String sourceDirectoryPath, String files) {
        StringTokenizer tokenizer = new StringTokenizer(files, ",");
        File destinationDirectory = new File(targetDirectoryName);
        while (tokenizer.hasMoreTokens()) {
            String sourceFile = tokenizer.nextToken().trim();
            int nameStartPosition = sourceFile.lastIndexOf(47) + 1;
            String sourceFileDirectory = nameStartPosition > 0 ? sourceFile.substring(0, nameStartPosition) : "";
            String sourceFileName = nameStartPosition > 0 ? sourceFile.substring(nameStartPosition) : sourceFile;
            FileUtils.copyFromResource((String)(sourceDirectoryPath + sourceFileDirectory), (String)sourceFileName, (File)destinationDirectory);
        }
    }

    private boolean copyIcons(MapModel map, String directoryName) {
        String iconDirectoryName = directoryName + File.separatorChar + "icons";
        boolean success = FileUtils.createDirectory((String)iconDirectoryName);
        if (success) {
            ExportWithXSLT.copyIconsToDirectory(map, iconDirectoryName);
        }
        return success;
    }

    private boolean copyMap(List<NodeModel> branches, String pDirectoryName, MapWriter.Mode mode) {
        boolean success = true;
        try {
            BufferedWriter fileout = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(pDirectoryName + File.separator + "map" + ".mm"), StandardCharsets.UTF_8));
            new BranchXmlWriter(branches).writeXml(fileout, mode);
        }
        catch (IOException e) {
            success = false;
        }
        return success;
    }

    private boolean createImageFromMap(MapModel map, String directoryName) {
        boolean bl;
        if (Controller.getCurrentController().getMapViewManager().getMapViewComponent() == null) {
            return false;
        }
        RenderedImage image = new ImageCreator(Math.round(UITools.FONT_SCALE_FACTOR * 72.0f)).createBufferedImage(map, 2);
        if (image == null) {
            return false;
        }
        FileOutputStream out = new FileOutputStream(directoryName + File.separator + "image.png");
        try {
            ImageIO.write(image, "png", out);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e1) {
                LogUtils.severe((Throwable)e1);
                return false;
            }
        }
        out.close();
        return bl;
    }

    private String getAreaCode(boolean create_image) {
        String areaCode = "";
        if (create_image) {
            areaCode = Controller.getCurrentController().getMapViewManager().createHtmlMap();
        }
        return areaCode;
    }

    private String getMapXml(List<NodeModel> nodes, MapWriter.Mode mode) throws IOException {
        StringWriter writer = new StringWriter();
        new BranchXmlWriter(nodes).writeXml(writer, mode);
        return writer.getBuffer().toString();
    }

    String getProperty(String key) {
        String property = this.getProperty(key, null);
        if (property == null) {
            return property;
        }
        Matcher r = propertyReferenceEpression.matcher(property);
        r.reset();
        boolean result = r.find();
        if (result) {
            StringBuffer sb = new StringBuffer();
            do {
                String propertyReference = r.group();
                String propertyName = propertyReference.substring(2, propertyReference.length() - 1);
                r.appendReplacement(sb, System.getProperty(propertyName, propertyReference));
            } while (result = r.find());
            r.appendTail(sb);
            return sb.toString();
        }
        return property;
    }

    String getProperty(String key, String value) {
        return this.properties.getProperty(key, value);
    }

    public boolean isTransformResultWithoutError() {
        return this.mTransformResultWithoutError;
    }

    @Override
    public void export(List<NodeModel> nodes, File saveFile) {
        try {
            this.mTransformResultWithoutError = true;
            boolean create_image = StringUtils.equals((String)this.getProperty("create_html_linked_image"), (String)"true");
            String areaCode = this.getAreaCode(create_image);
            String xsltFileName = this.getProperty("xslt_file");
            MapWriter.Mode mode = MapWriter.Mode.valueOf((String)this.getProperty("mode", MapWriter.Mode.EXPORT.name()));
            String[] parameters = this.getProperty("set_properties", "").split(",\\s*");
            boolean success = this.transformMapWithXslt(nodes, xsltFileName, saveFile, areaCode, mode, parameters);
            if (!success) {
                JOptionPane.showMessageDialog(UITools.getCurrentRootComponent(), this.getProperty("error_applying_template"), "Freeplane", 0);
                return;
            }
            if (success && StringUtils.equals((String)this.getProperty("create_dir"), (String)"true")) {
                String directoryName = saveFile.getAbsolutePath() + "_files";
                success = FileUtils.createDirectory((String)directoryName);
                if (success) {
                    String files = this.getProperty("files_to_copy");
                    String filePrefix = this.getProperty("file_prefix");
                    this.copyFilesFromResourcesToDirectory(directoryName, filePrefix, files);
                }
                MapModel map = nodes.get(0).getMap();
                if (success && StringUtils.equals((String)this.getProperty("copy_icons"), (String)"true")) {
                    success = this.copyIcons(map, directoryName);
                }
                if (success && StringUtils.equals((String)this.getProperty("copy_map"), (String)"true")) {
                    String copy\u041cap\u0425sltFile = this.getProperty("copy_map_xslt_file");
                    MapWriter.Mode copymode = MapWriter.Mode.valueOf((String)this.getProperty("copymode", MapWriter.Mode.EXPORT.name()));
                    success = copy\u041cap\u0425sltFile != null ? this.transformMapWithXslt(nodes, copy\u041cap\u0425sltFile, new File(directoryName, "map.mm"), "", copymode, new String[0]) : this.copyMap(nodes, directoryName, copymode);
                }
                if (success && create_image) {
                    success = this.createImageFromMap(map, directoryName);
                }
            }
            if (!success) {
                JOptionPane.showMessageDialog(UITools.getCurrentRootComponent(), this.getProperty("error_creating_directory"), "Freeplane", 0);
                return;
            }
            if (StringUtils.equals((String)this.getProperty("load_file"), (String)"true")) {
                Controller.getCurrentController().getViewController().openDocument(Compat.fileToUrl((File)saveFile));
            }
        }
        catch (Exception e) {
            LogUtils.severe((Throwable)e);
            this.mTransformResultWithoutError = false;
        }
    }

    private boolean transformMapWithXslt(List<NodeModel> nodes, String xsltFileName, File saveFile, String areaCode, MapWriter.Mode mode, String[] parameters) throws IOException, TransformerFactoryConfigurationError {
        String map = this.getMapXml(nodes, mode);
        StringReader reader = new StringReader(map);
        ResourceController resourceController = ResourceController.getResourceController();
        URL xsltUrl = resourceController.getResource(xsltFileName);
        if (xsltUrl == null) {
            LogUtils.severe((String)("Can't find " + xsltFileName + " as resource."));
            throw new IllegalArgumentException("Can't find " + xsltFileName + " as resource.");
        }
        try (BufferedInputStream xsltFile = new BufferedInputStream(xsltUrl.openStream());){
            StreamSource xsltSource = new StreamSource(xsltFile);
            StreamResult result = new StreamResult(saveFile);
            TransformerFactory transFact = TransformerFactory.newInstance();
            Transformer trans = transFact.newTransformer(xsltSource);
            trans.setParameter("file_ref", saveFile.getAbsoluteFile().toURI().toString());
            String fileName = saveFile.getName();
            String fileNameEncoded = this.toRelativeUri(fileName);
            trans.setParameter("destination_dir", fileNameEncoded + "_files/");
            trans.setParameter("area_code", areaCode);
            trans.setParameter("folding_type", resourceController.getProperty("html_export_folding"));
            StringBuilder sb = new StringBuilder();
            for (String p : parameters) {
                String value = resourceController.getProperty(p, null);
                if (value == null || value.equals(resourceController.getDefaultProperty(p))) continue;
                sb.append(p);
                sb.append('=');
                sb.append(value);
                sb.append("$$$");
            }
            trans.setParameter("propertyList", sb.toString());
            trans.transform(new StreamSource(reader), result);
        }
        catch (Exception e) {
            LogUtils.warn((Throwable)e);
            return false;
        }
        return true;
    }

    private String toRelativeUri(String fileName) throws URISyntaxException {
        return new URI(null, null, fileName, null).toString();
    }

    public FileFilter getFileFilter() {
        return new CaseSensitiveFileNameExtensionFilter(this.getProperty("file_type"), TextUtils.getText((String)(this.name + ".text")));
    }
}

