/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.layout.mindmapmode;

import javax.swing.Icon;
import javax.swing.JToggleButton;
import org.freeplane.api.ChildNodesLayout;
import org.freeplane.core.resources.components.ButtonPanelProperty;
import org.freeplane.core.ui.components.MultipleImageIcon;
import org.freeplane.core.ui.svgicons.FixSizeIconWrapper;
import org.freeplane.core.util.TextUtils;
import org.freeplane.features.layout.LayoutController;
import org.freeplane.features.layout.mindmapmode.LayoutSelectorPanelFactory;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.view.swing.map.MapViewController;
import org.freeplane.view.swing.map.NodeView;

public class ChildNodesLayoutButtonPanelProperty
extends ButtonPanelProperty {
    static final String CHILD_NODES_LAYOUTS = "children_nodes_layouts";

    public ChildNodesLayoutButtonPanelProperty() {
        super(CHILD_NODES_LAYOUTS, LayoutSelectorPanelFactory.createLayoutSelectorPanel());
        Icon icon = this.startButton.getIcon();
        int iconWidth = icon.getIconWidth() * 2 + LayoutSelectorPanelFactory.RIGHT_ARROW_ICON.getIconWidth();
        int iconHeight = icon.getIconHeight();
        this.startButton.setIcon((Icon)new FixSizeIconWrapper(iconWidth, iconHeight));
    }

    public void setValue(ChildNodesLayout value, ChildNodesLayout viewValue) {
        if (value == viewValue || viewValue == null) {
            super.setValue(value.name());
            return;
        }
        this.buttons.setValue(value.name());
        MultipleImageIcon multipleImageIcon = new MultipleImageIcon();
        JToggleButton selectedButton = this.buttons.getSelectedButton();
        JToggleButton viewButton = this.buttons.getButton(viewValue.name());
        multipleImageIcon.addIcon(selectedButton.getIcon());
        multipleImageIcon.addIcon(LayoutSelectorPanelFactory.RIGHT_ARROW_ICON);
        multipleImageIcon.addIcon(viewButton.getIcon());
        this.startButton.setIcon((Icon)multipleImageIcon);
        String labelKey = this.getLabel();
        String buttonName = TextUtils.getRawText((String)labelKey);
        this.startButton.setToolTipText(buttonName + ": " + selectedButton.getToolTipText() + ": " + viewButton.getToolTipText());
    }

    public void setStyleOnExternalChange(NodeModel node) {
        if (node == null) {
            this.setEnabled(false);
        } else {
            this.setEnabled(true);
            ChildNodesLayout displayedValue = this.displayedValue(node);
            NodeView nodeView = ((MapViewController)Controller.getCurrentController().getMapViewManager()).getMapView().getNodeView(node);
            if (nodeView == null) {
                this.setValue(displayedValue, displayedValue);
            } else {
                this.setValue(displayedValue, nodeView.recalculateChildNodesLayout());
            }
        }
    }

    private ChildNodesLayout displayedValue(NodeModel node) {
        LayoutController styleController = LayoutController.getController();
        ChildNodesLayout displayedValue = styleController.getChildNodesLayout(node);
        return displayedValue;
    }
}

