/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.link.mindmapmode.editor;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.awt.Color;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Optional;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.resources.components.BooleanProperty;
import org.freeplane.core.resources.components.ColorProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.link.ConnectorModel;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.link.mindmapmode.editor.ControlGroup;
import org.freeplane.features.link.mindmapmode.editor.ControlGroupChangeListener;

class ConnectorColorControlGroup
implements ControlGroup {
    private static final String CONNECTOR_COLOR = "connector_color";
    private BooleanProperty setColor;
    private ColorProperty color;
    private ConnectorColorChangeListener propertyChangeListener;
    private ConnectorModel connector;

    ConnectorColorControlGroup() {
    }

    @Override
    public void updateValue(ConnectorModel connector) {
        this.connector = connector;
        this.propertyChangeListener.update();
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.setColor = new BooleanProperty("set_property_text");
        this.color = new ColorProperty(CONNECTOR_COLOR, ResourceController.getResourceController().getProperty("connector_color_default"), false);
        this.propertyChangeListener = new ConnectorColorChangeListener(this.setColor, (IPropertyControl)this.color);
        this.setColor.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.color.addPropertyChangeListener((PropertyChangeListener)this.propertyChangeListener);
        this.setColor.appendToForm(formBuilder);
        this.color.appendToForm(formBuilder);
    }

    private class ConnectorColorChangeListener
    extends ControlGroupChangeListener {
        public ConnectorColorChangeListener(BooleanProperty mSet, IPropertyControl mProperty) {
            super(mSet, mProperty);
        }

        @Override
        void applyValue(boolean enabled, PropertyChangeEvent evt) {
            MLinkController linkController = (MLinkController)LinkController.getController();
            linkController.setConnectorColor(ConnectorColorControlGroup.this.connector, enabled ? Optional.of(ConnectorColorControlGroup.this.color.getColorValue()) : Optional.empty());
        }

        @Override
        void updateValue() {
            LinkController linkController = LinkController.getController();
            Optional ownColor = ConnectorColorControlGroup.this.connector.getColor();
            Color viewColor = linkController.getColor(ConnectorColorControlGroup.this.connector);
            ConnectorColorControlGroup.this.setColor.setValue(ownColor.isPresent());
            ConnectorColorControlGroup.this.color.setColorValue(viewColor);
        }
    }
}

