/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.features.styles.mindmapmode.styleeditorpanel;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JButton;
import org.freeplane.core.resources.components.ButtonProperty;
import org.freeplane.core.resources.components.IPropertyControl;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.features.mode.ModeController;
import org.freeplane.features.nodestyle.NodeCss;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroup;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.ControlGroupChangeListener;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.RevertingProperty;
import org.freeplane.features.styles.mindmapmode.styleeditorpanel.StylePropertyAdjuster;

class CssControlGroup
implements ControlGroup {
    static final String REVERT_CSS = "revert-css";
    static final String CSS = "css";
    private final RevertingProperty mSetCss = new RevertingProperty("revert-css");
    private final ButtonProperty mCssButton;
    private final CssChangeListener mPropertyListener;

    public CssControlGroup(ModeController modeController) {
        this.mCssButton = new ButtonProperty(CSS, new JButton((Action)modeController.getAction("EditNodeCssAction")));
        this.mPropertyListener = new CssChangeListener(this.mSetCss);
        this.mSetCss.addPropertyChangeListener(this.mPropertyListener);
        this.mCssButton.addPropertyChangeListener((PropertyChangeListener)this.mPropertyListener);
    }

    @Override
    public void addControlGroup(DefaultFormBuilder formBuilder) {
        this.addCssControl(formBuilder);
    }

    private void addCssControl(DefaultFormBuilder formBuilder) {
        this.mCssButton.appendToForm(formBuilder);
        this.mSetCss.appendToForm(formBuilder);
    }

    @Override
    public void setStyle(NodeModel node, boolean canEdit) {
        this.mPropertyListener.setStyle(node);
    }

    private class CssChangeListener
    extends ControlGroupChangeListener {
        public CssChangeListener(RevertingProperty mSet) {
            super(mSet, new IPropertyControl[0]);
        }

        @Override
        void applyValue(boolean enabled, NodeModel node, PropertyChangeEvent evt) {
            if (!enabled) {
                MNodeStyleController styleController = (MNodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
                styleController.setStyleSheet(node, null);
            }
        }

        @Override
        void setStyleOnExternalChange(NodeModel node) {
            CssControlGroup.this.mSetCss.setValue(node.getExtension(NodeCss.class) != null);
            NodeStyleController styleController = (NodeStyleController)Controller.getCurrentModeController().getExtension(NodeStyleController.class);
            NodeCss styleSheet = styleController.getStyleSheet(node, LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
            CssControlGroup.this.mCssButton.setToolTipText(styleSheet.css);
        }

        @Override
        void adjustForStyle(NodeModel node) {
            StylePropertyAdjuster.adjustPropertyControl(node, CssControlGroup.this.mSetCss);
            StylePropertyAdjuster.adjustPropertyControl(node, (IPropertyControl)CssControlGroup.this.mCssButton);
        }
    }
}

