/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.main.application;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.io.InputStream;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JWindow;
import org.freeplane.core.resources.ResourceController;
import org.freeplane.core.util.FreeplaneVersion;

public class FreeplaneSplashModern
extends JWindow {
    private static final long serialVersionUID = 1L;
    private static final String FREEPLANE_SPLASH_PNG = "/images/Freeplane_splash.png";
    private Font versionTextFont = null;
    private final ImageIcon splashImage;
    private final URL splashResource = ResourceController.getResourceController().getResource("/images/Freeplane_splash.png");

    public FreeplaneSplashModern(JFrame frame) {
        super(frame);
        this.splashImage = new ImageIcon(this.splashResource);
        GraphicsConfiguration gc = this.getGraphicsConfiguration();
        GraphicsDevice gd = gc.getDevice();
        int alpha = gd.isWindowTranslucencySupported(GraphicsDevice.WindowTranslucency.PERPIXEL_TRANSLUCENT) ? 0 : 255;
        this.setBackground(new Color(40, 75, 144, alpha));
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension labelSize = new Dimension(this.splashImage.getIconWidth(), this.splashImage.getIconHeight());
        this.setLocation(screenSize.width / 2 - labelSize.width / 2, screenSize.height / 2 - labelSize.height / 2);
        this.setSize(labelSize);
    }

    private void createVersionTextFont() {
        if (this.versionTextFont != null) {
            return;
        }
        try (InputStream fontInputStream = ResourceController.getResourceController().getResource("/fonts/gentium-subset.ttf").openStream();){
            this.versionTextFont = Font.createFont(0, fontInputStream);
        }
        catch (Exception e) {
            this.versionTextFont = new Font("Arial", 0, 12);
        }
    }

    @Override
    public void paint(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        this.splashImage.paintIcon(this, g2, 0, 0);
        String splashResourceType = this.splashResource.getProtocol();
        String classResourceType = this.getClass().getResource(FreeplaneSplashModern.class.getSimpleName() + ".class").getProtocol();
        if (!splashResourceType.equals(classResourceType)) {
            return;
        }
        g2.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        FreeplaneVersion version = FreeplaneVersion.getVersion();
        String versionString = this.getVersionText(version);
        g2.setColor(Color.WHITE);
        this.createVersionTextFont();
        float versionFontSize = 20.0f;
        g2.setFont(this.versionTextFont.deriveFont(20.0f));
        int versionStringWidth = g2.getFontMetrics().stringWidth(versionString);
        int distanceToRightEdge = 48;
        int xCoordinate = this.splashImage.getIconWidth() - versionStringWidth - distanceToRightEdge;
        int yCoordinate = 28;
        g2.drawString(versionString, xCoordinate, 28);
    }

    private String getVersionText(FreeplaneVersion version) {
        String freeplaneNumber = version.numberToString();
        String status = version.getType().toLowerCase();
        if ("".equals(status)) {
            return freeplaneNumber;
        }
        String versionString = freeplaneNumber + " " + status;
        return versionString;
    }

    @Override
    public void setVisible(boolean b) {
        super.setVisible(b);
        if (b) {
            this.paintImmediately();
        }
    }

    public void paintImmediately() {
        this.getRootPane().paintImmediately(0, 0, this.getWidth(), this.getHeight());
    }
}

