/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fo.flow.table;

import java.util.BitSet;
import java.util.List;
import org.apache.fop.fo.flow.table.PendingSpan;

public class ColumnNumberManager {
    private int columnNumber = 1;
    private BitSet usedColumnIndices = new BitSet();

    int getCurrentColumnNumber() {
        return this.columnNumber;
    }

    void signalUsedColumnNumbers(int start, int end) {
        for (int i = start - 1; i < end; ++i) {
            this.usedColumnIndices.set(i);
        }
        this.columnNumber = end + 1;
        while (this.usedColumnIndices.get(this.columnNumber - 1)) {
            ++this.columnNumber;
        }
    }

    void prepareForNextRow(List pendingSpans) {
        this.usedColumnIndices.clear();
        for (int i = 0; i < pendingSpans.size(); ++i) {
            PendingSpan pSpan = (PendingSpan)pendingSpans.get(i);
            if (pSpan == null) continue;
            if (pSpan.decrRowsLeft() == 0) {
                pendingSpans.set(i, null);
                continue;
            }
            this.usedColumnIndices.set(i);
        }
        this.columnNumber = 1;
        while (this.usedColumnIndices.get(this.columnNumber - 1)) {
            ++this.columnNumber;
        }
    }

    public boolean isColumnNumberUsed(int colNr) {
        return this.usedColumnIndices.get(colNr - 1);
    }
}

