/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

public final class FontUtil {
    private static final String[] ITALIC_WORDS = new String[]{"italic", "oblique", "inclined"};
    private static final String[] LIGHT_WORDS = new String[]{"light"};
    private static final String[] MEDIUM_WORDS = new String[]{"medium"};
    private static final String[] DEMI_WORDS = new String[]{"demi", "semi"};
    private static final String[] BOLD_WORDS = new String[]{"bold"};
    private static final String[] EXTRA_BOLD_WORDS = new String[]{"extrabold", "extra bold", "black", "heavy", "ultra", "super"};

    private FontUtil() {
    }

    public static int parseCSS2FontWeight(String text) {
        int weight = 400;
        try {
            weight = Integer.parseInt(text);
            weight = weight / 100 * 100;
            weight = Math.max(weight, 100);
            weight = Math.min(weight, 900);
        }
        catch (NumberFormatException nfe) {
            if (text.equals("normal")) {
                weight = 400;
            }
            if (text.equals("bold")) {
                weight = 700;
            }
            throw new IllegalArgumentException("Illegal value for font weight: '" + text + "'. Use one of: 100, 200, 300, 400, 500, 600, 700, 800, 900, normal (=400), bold (=700)");
        }
        return weight;
    }

    public static String stripWhiteSpace(String str) {
        if (str != null) {
            StringBuffer stringBuffer = new StringBuffer(str.length());
            int strLen = str.length();
            for (int i = 0; i < strLen; ++i) {
                char ch = str.charAt(i);
                if (ch == ' ' || ch == '\r' || ch == '\n' || ch == '\t') continue;
                stringBuffer.append(ch);
            }
            return stringBuffer.toString();
        }
        return str;
    }

    public static String guessStyle(String fontName) {
        if (fontName != null) {
            for (String word : ITALIC_WORDS) {
                if (fontName.indexOf(word) == -1) continue;
                return "italic";
            }
        }
        return "normal";
    }

    public static int guessWeight(String fontName) {
        int weight = 400;
        for (String word : BOLD_WORDS) {
            if (fontName.indexOf(word) == -1) continue;
            weight = 700;
            break;
        }
        for (String word : MEDIUM_WORDS) {
            if (fontName.indexOf(word) == -1) continue;
            weight = 500;
            break;
        }
        for (String word : DEMI_WORDS) {
            if (fontName.indexOf(word) == -1) continue;
            weight = 600;
            break;
        }
        for (String word : EXTRA_BOLD_WORDS) {
            if (fontName.indexOf(word) == -1) continue;
            weight = 800;
            break;
        }
        for (String word : LIGHT_WORDS) {
            if (fontName.indexOf(word) == -1) continue;
            weight = 200;
            break;
        }
        return weight;
    }
}

