/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineFactory;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import javax.script.SimpleScriptContext;
import org.apache.commons.io.FilenameUtils;
import org.freeplane.core.util.FileUtils;
import org.freeplane.features.map.IMapSelection;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.mode.Controller;
import org.freeplane.plugin.script.CompileTimeStrategy;
import org.freeplane.plugin.script.ExecuteScriptException;
import org.freeplane.plugin.script.IFreeplaneScriptErrorHandler;
import org.freeplane.plugin.script.IScript;
import org.freeplane.plugin.script.ScriptClassLoader;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.ScriptEngineNotLoadedException;
import org.freeplane.plugin.script.ScriptResources;
import org.freeplane.plugin.script.ScriptSecurity;
import org.freeplane.plugin.script.ScriptingConfiguration;
import org.freeplane.plugin.script.ScriptingPermissions;
import org.freeplane.plugin.script.ScriptingSecurityManager;
import org.freeplane.plugin.script.proxy.ProxyFactory;

public class GenericScript
implements IScript {
    private ScriptSource scriptSource;
    private ScriptingPermissions specificPermissions;
    private CompiledScript compiledScript;
    private Throwable errorsInScript;
    private ScriptEngine engine;
    private boolean compilationEnabled = true;
    private CompileTimeStrategy compileTimeStrategy;
    private ScriptClassLoader scriptClassLoader;

    private void init(ScriptSource scriptSource, ScriptingPermissions permissions) {
        this.scriptSource = scriptSource;
        this.specificPermissions = permissions;
        this.engine = null;
        this.compiledScript = null;
        this.errorsInScript = null;
        this.scriptClassLoader = ScriptClassLoader.createClassLoader();
    }

    private void init(String script, ScriptingPermissions permissions) {
        this.init(new ScriptSource(script), permissions);
        this.compileTimeStrategy = new CompileTimeStrategy(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericScript(String script, String type, ScriptingPermissions permissions) {
        this.init(script, permissions);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.scriptClassLoader));
            ScriptEngineManager scriptEngineManager = GenericScript.createScriptEngineManager((ClassLoader)((Object)this.scriptClassLoader));
            ScriptEngine engineByExtension = scriptEngineManager.getEngineByExtension(type);
            ScriptEngine engine = engineByExtension != null ? engineByExtension : scriptEngineManager.getEngineByName(type);
            this.engine = GenericScript.checkNotNull(engine, type);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public GenericScript(File scriptFile, ScriptingPermissions permissions) {
        this.init(new ScriptSource(scriptFile), permissions);
        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.scriptClassLoader));
            ScriptEngineManager scriptEngineManager = GenericScript.createScriptEngineManager((ClassLoader)((Object)this.scriptClassLoader));
            String extension = FilenameUtils.getExtension((String)scriptFile.getName());
            this.engine = this.getEngineByExtension(scriptEngineManager, extension);
        }
        finally {
            Thread.currentThread().setContextClassLoader(contextClassLoader);
        }
        this.compilationEnabled = !this.disableScriptCompilation(scriptFile);
        this.compileTimeStrategy = new CompileTimeStrategy(scriptFile);
    }

    private ScriptEngine getEngineByExtension(ScriptEngineManager scriptEngineManager, String extension) {
        if (extension.equalsIgnoreCase("js")) {
            return this.getJsEngineSuppressFalseErrorMessage(scriptEngineManager);
        }
        return GenericScript.checkNotNull(scriptEngineManager.getEngineByExtension(extension), extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ScriptEngine getJsEngineSuppressFalseErrorMessage(ScriptEngineManager scriptEngineManager) {
        PrintStream err = System.err;
        System.setErr(System.out);
        try {
            String extension = "js";
            ScriptEngine scriptEngine = GenericScript.checkNotNull(scriptEngineManager.getEngineByExtension(extension), extension);
            return scriptEngine;
        }
        finally {
            System.setErr(err);
        }
    }

    private static String slurpFile(File scriptFile) {
        try {
            return FileUtils.slurpFile((File)scriptFile);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object execute(NodeModel node, final PrintStream outStream, IFreeplaneScriptErrorHandler errorHandler, ScriptContext scriptContext) {
        try {
            if (this.errorsInScript != null && this.compileTimeStrategy.canUseOldCompiledScript()) {
                throw new ExecuteScriptException(this.errorsInScript.getMessage(), this.errorsInScript);
            }
            PrintStream oldOut = System.out;
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        ScriptingSecurityManager scriptingSecurityManager = GenericScript.this.createScriptingSecurityManager(outStream);
                        GenericScript.this.scriptClassLoader.setSecurityManager(scriptingSecurityManager);
                        return null;
                    }
                });
                Thread.currentThread().setContextClassLoader((ClassLoader)((Object)this.scriptClassLoader));
                SimpleScriptContext context = this.createScriptContext(node, scriptContext, outStream);
                if (this.compilationEnabled && this.engine instanceof Compilable) {
                    this.compileAndCache((Compilable)((Object)this.engine));
                    System.setOut(outStream);
                    Object object = this.compiledScript.eval(context);
                    return object;
                }
                System.setOut(outStream);
                Object object = this.engine.eval(this.scriptSource.getScript(), (javax.script.ScriptContext)context);
                return object;
            }
            finally {
                System.setOut(oldOut);
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
        }
        catch (ScriptException e) {
            this.handleScriptRuntimeException(e, outStream, errorHandler);
            throw new RuntimeException(e);
        }
        catch (Throwable e) {
            IMapSelection selection = Controller.getCurrentController().getSelection();
            if (selection == null) throw new ExecuteScriptException(e.getMessage(), e);
            if (node == null) throw new ExecuteScriptException(e.getMessage(), e);
            if (selection.getMap() != node.getMap()) throw new ExecuteScriptException(e.getMessage(), e);
            if (!node.hasVisibleContent(selection.getFilter())) throw new ExecuteScriptException(e.getMessage(), e);
            Controller.getCurrentModeController().getMapController().select(node);
            throw new ExecuteScriptException(e.getMessage(), e);
        }
    }

    private ScriptingSecurityManager createScriptingSecurityManager(PrintStream outStream) {
        return new ScriptSecurity(this.scriptSource, this.specificPermissions, outStream).getScriptingSecurityManager();
    }

    private boolean disableScriptCompilation(File scriptFile) {
        return FilenameUtils.isExtension((String)scriptFile.getName(), (String[])ScriptResources.SCRIPT_COMPILATION_DISABLED_EXTENSIONS);
    }

    private SimpleScriptContext createScriptContext(NodeModel node, ScriptContext scriptContext, OutputStream outStream) {
        SimpleScriptContext context = new SimpleScriptContext();
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream);
        context.setWriter(outWriter);
        context.setErrorWriter(outWriter);
        context.setBindings(this.createBinding(node, scriptContext), 100);
        return context;
    }

    private Bindings createBinding(NodeModel node, ScriptContext scriptContext) {
        Bindings binding = this.engine.createBindings();
        binding.put("c", (Object)ProxyFactory.createController(scriptContext));
        binding.put("node", (Object)ProxyFactory.createNode(node, scriptContext));
        binding.putAll((Map<? extends String, ? extends Object>)ScriptingConfiguration.getStaticProperties());
        return binding;
    }

    private static ScriptEngineManager createScriptEngineManager(ClassLoader classLoader) {
        ScriptEngineManager scriptEngineManager = new ScriptEngineManager(classLoader);
        return scriptEngineManager;
    }

    static List<ScriptEngineFactory> createScriptEngineFactories() {
        ScriptClassLoader classLoader = ScriptClassLoader.createClassLoader();
        return GenericScript.createScriptEngineManager((ClassLoader)((Object)classLoader)).getEngineFactories();
    }

    private void compileAndCache(Compilable engine) throws Throwable {
        if (this.compileTimeStrategy.canUseOldCompiledScript()) {
            return;
        }
        this.compiledScript = null;
        this.errorsInScript = null;
        try {
            this.scriptSource.rereadFile();
            this.compileTimeStrategy.scriptCompileStart();
            this.compiledScript = engine.compile(this.scriptSource.getScript());
            this.compileTimeStrategy.scriptCompiled();
        }
        catch (Throwable e) {
            this.errorsInScript = e;
            throw e;
        }
    }

    private static ScriptEngine checkNotNull(ScriptEngine motor, String detail) {
        if (motor == null) {
            throw new ScriptEngineNotLoadedException("can't load script engine " + detail);
        }
        return motor;
    }

    private void handleScriptRuntimeException(ScriptException e, PrintStream outStream, IFreeplaneScriptErrorHandler errorHandler) {
        outStream.print("message: " + e.getMessage());
        int lineNumber = e.getLineNumber();
        outStream.print("Line number: " + lineNumber);
        errorHandler.gotoLine(lineNumber);
        throw new ExecuteScriptException(e.getMessage() + " at line " + lineNumber, e.getCause() == null ? e : e.getCause());
    }

    @Override
    public boolean hasPermissions(ScriptingPermissions permissions) {
        if (this.specificPermissions == null) {
            return this.specificPermissions == permissions;
        }
        return this.specificPermissions.equals(permissions);
    }

    public static final class ScriptSource {
        private final File file;
        private final String script;
        private String cachedFileContent;

        public ScriptSource(String script) {
            this.script = script;
            this.file = null;
        }

        public ScriptSource(File file) {
            this.script = null;
            this.file = file;
            this.cachedFileContent = GenericScript.slurpFile(file);
        }

        public boolean isFile() {
            return this.file != null;
        }

        public String rereadFile() {
            this.cachedFileContent = GenericScript.slurpFile(this.file);
            return this.cachedFileContent;
        }

        public String getScript() {
            return this.isFile() ? this.cachedFileContent : this.script;
        }

        public String getPath() {
            return this.isFile() ? this.file.getAbsolutePath() : null;
        }
    }
}

