/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.dependencies;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.freeplane.api.Dependencies;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.attribute.NodeAttributeTableModel;

public class DependenciesBuilder {
    private final NodeAttributeTableModel attributes;
    private boolean isNodeContained = false;
    private ArrayList<Integer> attributeList;

    public DependenciesBuilder(NodeAttributeTableModel attributes) {
        this.attributes = attributes;
    }

    public void setNodeContained() {
        this.isNodeContained = true;
    }

    public void addAttribute(Attribute attribute) {
        int attributeIndex;
        if (this.attributeList == null) {
            this.attributeList = new ArrayList();
        }
        if ((attributeIndex = this.attributes.getAttributeIndex(attribute)) < 0) {
            throw new IllegalArgumentException("Attribute not found");
        }
        this.attributeList.add(attributeIndex);
    }

    public Dependencies build() {
        List<Object> elements = this.isNodeContained ? Collections.singletonList(Dependencies.Element.NODE) : Collections.emptyList();
        return new Dependencies(elements, this.attributeList != null ? this.attributeList : Collections.emptyList());
    }
}

