/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.dependencies;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.freeplane.features.attribute.Attribute;
import org.freeplane.features.map.MapModel;
import org.freeplane.features.map.NodeModel;

public class RelatedElements {
    private final Map<Object, NodeModel> relatedElements;
    private final NodeModel relatedNode;
    private Set<MapModel> relatedMaps;

    public RelatedElements(NodeModel relatedNode) {
        this.relatedNode = relatedNode;
        this.relatedElements = new HashMap<Object, NodeModel>();
    }

    public void relateAttribute(NodeModel relatedNode, Attribute attribute) {
        if (this.relatedNode.getMap() == relatedNode.getMap()) {
            this.relatedElements.put(attribute, relatedNode);
        }
    }

    public void relateNode(NodeModel accessedNode) {
        if (this.relatedNode.getMap() == accessedNode.getMap()) {
            this.relatedElements.put(accessedNode, accessedNode);
        }
    }

    public void relateMap(MapModel accessedMap) {
        if (this.relatedNode.getMap() != accessedMap) {
            this.add(accessedMap);
        }
    }

    private void add(MapModel accessedMap) {
        if (this.relatedMaps == null) {
            this.relatedMaps = new HashSet<MapModel>();
        }
        this.relatedMaps.add(accessedMap);
    }

    public boolean isEmpty() {
        return this.relatedElements.isEmpty();
    }

    public Collection<NodeModel> getRelatedNodes() {
        return this.relatedElements.values();
    }

    public Collection<Object> getElements() {
        return this.relatedElements.keySet();
    }

    public Set<Map.Entry<Object, NodeModel>> entrySet() {
        return this.relatedElements.entrySet();
    }
}

