/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.awt.Color;
import org.freeplane.api.Dash;
import org.freeplane.api.LengthUnit;
import org.freeplane.api.Quantity;
import org.freeplane.core.util.ColorUtils;
import org.freeplane.features.map.NodeModel;
import org.freeplane.features.nodestyle.NodeBorderModel;
import org.freeplane.features.nodestyle.NodeStyleController;
import org.freeplane.features.nodestyle.mindmapmode.MNodeStyleController;
import org.freeplane.features.styles.LogicalStyleController;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.Proxy;

public class BorderProxy
extends AbstractProxy<NodeModel>
implements Proxy.Border {
    BorderProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    private MNodeStyleController getStyleController() {
        return (MNodeStyleController)NodeStyleController.getController();
    }

    public void setColor(Color color) {
        this.getStyleController().setBorderColor((NodeModel)this.getDelegate(), color);
    }

    public void setColorCode(String rgbString) {
        this.setColor(ColorUtils.stringToColor((String)rgbString));
    }

    public Color getColor() {
        return this.getStyleController().getBorderColor((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public String getColorCode() {
        return ColorUtils.colorToString((Color)this.getColor());
    }

    public boolean isColorSet() {
        NodeBorderModel border = NodeBorderModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
        return border != null && border.getBorderColor() != null;
    }

    public Quantity<LengthUnit> getWidth() {
        return this.getStyleController().getBorderWidth((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public boolean isWidthSet() {
        NodeBorderModel border = NodeBorderModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
        return border != null && border.getBorderWidth() != null;
    }

    public void setWidth(Quantity<LengthUnit> borderWidth) {
        this.getStyleController().setBorderWidth((NodeModel)this.getDelegate(), borderWidth);
    }

    public void setWidth(Integer borderWidth) {
        Quantity borderWidthQuantity = new Quantity((double)borderWidth.intValue(), (Enum)LengthUnit.px);
        this.setWidth((Quantity<LengthUnit>)borderWidthQuantity);
    }

    public void setWidth(String borderWidth) {
        Quantity borderWidthQuantity = Quantity.fromString((String)borderWidth, (Enum)LengthUnit.px);
        this.setWidth((Quantity<LengthUnit>)borderWidthQuantity);
    }

    public Dash getDash() {
        return this.getStyleController().getBorderDash((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public boolean isDashSet() {
        NodeBorderModel border = NodeBorderModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
        return border != null && border.getBorderDash() != null;
    }

    public void setDash(Dash dash) {
        this.getStyleController().setBorderDash((NodeModel)this.getDelegate(), dash);
    }

    public void setUsesEdgeColor(Boolean borderColorMatchesEdgeColor) {
        this.getStyleController().setBorderColorMatchesEdgeColor((NodeModel)this.getDelegate(), borderColorMatchesEdgeColor);
    }

    public void setUsesEdgeWidth(Boolean borderWidthMatchesEdgeWidth) {
        this.getStyleController().setBorderWidthMatchesEdgeWidth((NodeModel)this.getDelegate(), borderWidthMatchesEdgeWidth);
    }

    public void setUsesEdgeDash(Boolean borderDashMatchesEdgeDash) {
        this.getStyleController().setBorderDashMatchesEdgeDash((NodeModel)this.getDelegate(), borderDashMatchesEdgeDash);
    }

    public boolean getUsesEdgeColor() {
        return this.getStyleController().getBorderColorMatchesEdgeColor((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public boolean getUsesEdgeWidth() {
        return this.getStyleController().getBorderWidthMatchesEdgeWidth((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public boolean getUsesEdgeDash() {
        return this.getStyleController().getBorderDashMatchesEdgeDash((NodeModel)this.getDelegate(), LogicalStyleController.StyleOption.FOR_UNSELECTED_NODE);
    }

    public boolean isUsesEdgeColorSet() {
        NodeBorderModel border = NodeBorderModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
        return border != null && border.getBorderColorMatchesEdgeColor() != null;
    }

    public boolean isUsesEdgeWidthSet() {
        NodeBorderModel border = NodeBorderModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
        return border != null && border.getBorderWidthMatchesEdgeWidth() != null;
    }

    public boolean isUsesEdgeDashSet() {
        NodeBorderModel border = NodeBorderModel.getModel((NodeModel)((NodeModel)this.getDelegate()));
        return border != null && border.getBorderDashMatchesEdgeDash() != null;
    }
}

