/*
 * Decompiled with CFR 0.152.
 */
package org.freeplane.plugin.script.proxy;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.lang.SystemUtils;
import org.freeplane.api.Node;
import org.freeplane.core.util.Hyperlink;
import org.freeplane.core.util.LogUtils;
import org.freeplane.features.explorer.MapExplorerController;
import org.freeplane.features.link.LinkController;
import org.freeplane.features.link.NodeLinks;
import org.freeplane.features.link.mindmapmode.MLinkController;
import org.freeplane.features.map.NodeModel;
import org.freeplane.plugin.script.ScriptContext;
import org.freeplane.plugin.script.proxy.AbstractProxy;
import org.freeplane.plugin.script.proxy.NodeProxy;
import org.freeplane.plugin.script.proxy.Proxy;

class LinkProxy
extends AbstractProxy<NodeModel>
implements Proxy.Link {
    LinkProxy(NodeModel delegate, ScriptContext scriptContext) {
        super(delegate, scriptContext);
    }

    public String getText() {
        URI link = this.getUri();
        return link == null ? null : link.toString();
    }

    public URI getUri() {
        Hyperlink hyperlink = NodeLinks.getLink((NodeModel)((NodeModel)this.getDelegate()));
        return hyperlink != null ? hyperlink.getUri() : null;
    }

    public File getFile() {
        URI link = this.getUri();
        try {
            if (link == null) {
                return null;
            }
            if (this.isFileUri(link)) {
                String uriPathForFile = LinkProxy.calcUriPathForFile(link);
                File fileFromUriPath = new File(uriPathForFile);
                if (fileFromUriPath.isAbsolute()) {
                    return fileFromUriPath;
                }
                File mapFile = ((NodeModel)this.getDelegate()).getMap().getFile();
                return mapFile == null ? null : new File(mapFile.getParent(), uriPathForFile);
            }
            return new File(link);
        }
        catch (Exception e) {
            return null;
        }
    }

    private static String calcUriPathForFile(URI link) {
        String uriPathForFile = "freeplane".equals(link.getScheme()) ? link.getPath().replaceFirst("^/ ", "") : link.getPath();
        if (SystemUtils.IS_OS_WINDOWS && uriPathForFile.startsWith("../")) {
            uriPathForFile = uriPathForFile.replaceFirst("^(../)+(?=[a-zA-Z]:/)", "");
        }
        return uriPathForFile;
    }

    private boolean isFileUri(URI link) {
        return link.getScheme() == null || link.getScheme().equals("file") || link.getScheme().equals("freeplane");
    }

    public Node getNode() {
        URI uri = this.getUri();
        if (uri == null) {
            return null;
        }
        String link = uri.toString();
        if (!link.startsWith("#")) {
            return null;
        }
        NodeModel targetNode = this.resolve(link);
        if (targetNode == null) {
            LogUtils.warn((String)(link + ": node does not exist (anymore?)"));
            return null;
        }
        return new NodeProxy(targetNode, this.getScriptContext());
    }

    private NodeModel resolve(String link) {
        return ((MapExplorerController)this.getModeController().getExtension(MapExplorerController.class)).getNodeAt((NodeModel)this.getDelegate(), link.substring(1));
    }

    @Deprecated
    public String get() {
        Hyperlink link = NodeLinks.getValidLink((NodeModel)((NodeModel)this.getDelegate()));
        return link == null ? null : link.toString();
    }

    private MLinkController getLinkController() {
        return (MLinkController)LinkController.getController();
    }

    public void setText(String target) {
        try {
            if (!this.removeLinkIfNull(target)) {
                this.getLinkController().setLink((NodeModel)this.getDelegate(), new URI(target), 0);
            }
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public void setUri(URI target) {
        if (!this.removeLinkIfNull(target)) {
            this.getLinkController().setLink((NodeModel)this.getDelegate(), target, 0);
        }
    }

    public void setFile(File file) {
        if (!this.removeLinkIfNull(file)) {
            this.getLinkController().setLink((NodeModel)this.getDelegate(), file.toURI(), 0);
        }
    }

    public void setNode(Node node) {
        if (!this.removeLinkIfNull(node)) {
            if (this.getModeController().getMapController().getNodeFromID_(node.getId()) == null) {
                throw new IllegalArgumentException("target node " + node.toString() + " belongs to a different map");
            }
            this.setText("#" + node.getId());
        }
    }

    @Deprecated
    public boolean set(String target) {
        try {
            this.setText(target);
            return true;
        }
        catch (RuntimeException e) {
            LogUtils.warn((Throwable)e);
            return false;
        }
    }

    private boolean removeLinkIfNull(Object target) {
        if (target == null) {
            this.getLinkController().setLink((NodeModel)this.getDelegate(), (URI)null, 0);
            return true;
        }
        return false;
    }

    public boolean asBoolean() {
        return this.getUri() != null;
    }

    public boolean remove() {
        return this.removeLinkIfNull(null);
    }
}

