/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.docking.AbstractTabWindow;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.RootWindow;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drag.DockingWindowDragSource;
import net.infonode.docking.drag.DockingWindowDragger;
import net.infonode.docking.drag.DockingWindowDraggerProvider;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.internalutil.CloseButtonInfo;
import net.infonode.docking.internalutil.DockButtonInfo;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.internalutil.MaximizeButtonInfo;
import net.infonode.docking.internalutil.MinimizeButtonInfo;
import net.infonode.docking.internalutil.RestoreButtonInfo;
import net.infonode.docking.internalutil.UndockButtonInfo;
import net.infonode.docking.model.TabWindowItem;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.properties.base.Property;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;
import net.infonode.properties.util.PropertyChangeListener;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;

public class TabWindow
extends AbstractTabWindow {
    private static final ButtonInfo[] buttonInfos = new ButtonInfo[]{new UndockButtonInfo(TabWindowProperties.UNDOCK_BUTTON_PROPERTIES), new DockButtonInfo(TabWindowProperties.DOCK_BUTTON_PROPERTIES), new MinimizeButtonInfo(TabWindowProperties.MINIMIZE_BUTTON_PROPERTIES), new MaximizeButtonInfo(TabWindowProperties.MAXIMIZE_BUTTON_PROPERTIES), new RestoreButtonInfo(TabWindowProperties.RESTORE_BUTTON_PROPERTIES), new CloseButtonInfo(TabWindowProperties.CLOSE_BUTTON_PROPERTIES)};
    private AbstractButton[] buttons;
    private PropertyChangeListener minimumSizePropertiesListener;
    private PropertyMapTreeListener buttonFactoryListener;

    public TabWindow() {
        this((DockingWindow)null);
    }

    public TabWindow(DockingWindow window) {
        DockingWindow[] dockingWindowArray;
        if (window == null) {
            dockingWindowArray = null;
        } else {
            DockingWindow[] dockingWindowArray2 = new DockingWindow[1];
            dockingWindowArray = dockingWindowArray2;
            dockingWindowArray2[0] = window;
        }
        this(dockingWindowArray);
    }

    public TabWindow(DockingWindow[] windows) {
        this(windows, null);
    }

    protected TabWindow(DockingWindow[] windows, TabWindowItem windowItem) {
        super(true, windowItem == null ? new TabWindowItem() : windowItem);
        this.buttons = new AbstractButton[buttonInfos.length];
        this.minimumSizePropertiesListener = new PropertyChangeListener(){

            @Override
            public void propertyChanged(Property property, Object valueContainer, Object oldValue, Object newValue) {
                TabWindow.this.revalidate();
            }
        };
        this.buttonFactoryListener = new PropertyMapTreeListener(){

            @Override
            public void propertyValuesChanged(Map changes) {
                TabWindow.this.doUpdateButtonVisibility(changes);
            }
        };
        this.setTabWindowProperties(((TabWindowItem)this.getWindowItem()).getTabWindowProperties());
        PropertyMapWeakListenerManager.addWeakPropertyChangeListener(this.getTabWindowProperties().getMap(), TabWindowProperties.RESPECT_CHILD_WINDOW_MINIMUM_SIZE, this.minimumSizePropertiesListener);
        new DockingWindowDragSource(this.getTabbedPanel(), new DockingWindowDraggerProvider(){

            @Override
            public DockingWindowDragger getDragger(MouseEvent mouseEvent) {
                if (!TabWindow.this.getWindowProperties().getDragEnabled()) {
                    return null;
                }
                Point p = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), mouseEvent.getPoint(), TabWindow.this.getTabbedPanel());
                return TabWindow.this.getTabbedPanel().tabAreaContainsPoint(p) ? (TabWindow.this.getChildWindowCount() == 1 ? TabWindow.this.getChildWindow(0) : TabWindow.this).startDrag(TabWindow.this.getRootWindow()) : null;
            }
        });
        this.initMouseListener();
        this.init();
        this.getTabbedPanel().addTabListener(new TabAdapter(){

            @Override
            public void tabAdded(TabEvent event) {
                TabWindow.this.doUpdateButtonVisibility(null);
            }

            @Override
            public void tabRemoved(TabRemovedEvent event) {
                TabWindow.this.doUpdateButtonVisibility(null);
            }
        });
        if (windows != null) {
            int i = 0;
            while (i < windows.length) {
                this.addTab(windows[i]);
                ++i;
            }
        }
        PropertyMapWeakListenerManager.addWeakTreeListener(this.getTabWindowProperties().getMap(), this.buttonFactoryListener);
    }

    @Override
    public TabWindowProperties getTabWindowProperties() {
        return ((TabWindowItem)this.getWindowItem()).getTabWindowProperties();
    }

    @Override
    protected void tabSelected(WindowTab tab) {
        super.tabSelected(tab);
        if (this.getUpdateModel()) {
            ((TabWindowItem)this.getWindowItem()).setSelectedItem(tab == null ? null : this.getWindowItem().getChildWindowContaining(tab.getWindow().getWindowItem()));
        }
    }

    @Override
    protected void update() {
    }

    @Override
    protected void updateButtonVisibility() {
        this.doUpdateButtonVisibility(null);
    }

    private void doUpdateButtonVisibility(Map changes) {
        if (InternalDockingUtil.updateButtons(buttonInfos, this.buttons, null, this, this.getTabWindowProperties().getMap(), changes)) {
            this.updateTabAreaComponents();
        }
        super.updateButtonVisibility();
    }

    @Override
    protected int getTabAreaComponentCount() {
        return ArrayUtil.countNotNull(this.buttons);
    }

    @Override
    protected void getTabAreaComponents(int index, JComponent[] components) {
        int i = 0;
        while (i < this.buttons.length) {
            if (this.buttons[i] != null) {
                components[index++] = this.buttons[i];
            }
            ++i;
        }
    }

    @Override
    protected void optimizeWindowLayout() {
        if (this.getWindowParent() == null) {
            return;
        }
        if (this.getTabbedPanel().getTabCount() == 0) {
            this.internalClose();
        } else if (this.getTabbedPanel().getTabCount() == 1 && (this.getWindowParent().showsWindowTitle() || !this.getChildWindow(0).needsTitleWindow())) {
            this.getWindowParent().internalReplaceChildWindow(this, this.getChildWindow(0).getBestFittedWindow(this.getWindowParent()));
        }
    }

    @Override
    public int addTab(DockingWindow w, int index) {
        int actualIndex = super.addTab(w, index);
        this.setSelectedTab(actualIndex);
        return actualIndex;
    }

    @Override
    protected int addTabNoSelect(DockingWindow window, int index) {
        DockingWindow beforeWindow = index == this.getChildWindowCount() ? null : this.getChildWindow(index);
        int i = super.addTabNoSelect(window, index);
        if (this.getUpdateModel()) {
            this.addWindowItem(window, beforeWindow == null ? -1 : this.getWindowItem().getWindowIndex(this.getWindowItem().getChildWindowContaining(beforeWindow.getWindowItem())));
        }
        return i;
    }

    @Override
    protected void updateWindowItem(RootWindow rootWindow) {
        super.updateWindowItem(rootWindow);
        ((TabWindowItem)this.getWindowItem()).setParentTabWindowProperties(rootWindow == null ? TabWindowItem.emptyProperties : rootWindow.getRootWindowProperties().getTabWindowProperties());
    }

    @Override
    protected PropertyMap getPropertyObject() {
        return this.getTabWindowProperties().getMap();
    }

    @Override
    protected PropertyMap createPropertyObject() {
        return new TabWindowProperties().getMap();
    }

    @Override
    protected int getEdgeDepth(Direction dir) {
        return dir == this.getTabbedPanel().getProperties().getTabAreaOrientation() ? 1 : super.getEdgeDepth(dir);
    }

    @Override
    protected int getChildEdgeDepth(DockingWindow window, Direction dir) {
        return dir == this.getTabbedPanel().getProperties().getTabAreaOrientation() ? 0 : 1 + super.getChildEdgeDepth(window, dir);
    }

    @Override
    protected DockingWindow getOptimizedWindow() {
        return this.getChildWindowCount() == 1 ? this.getChildWindow(0).getOptimizedWindow() : super.getOptimizedWindow();
    }

    @Override
    protected boolean acceptsSplitWith(DockingWindow window) {
        return super.acceptsSplitWith(window) && (this.getChildWindowCount() != 1 || this.getChildWindow(0) != window);
    }

    @Override
    protected DockingWindow getBestFittedWindow(DockingWindow parentWindow) {
        return this.getChildWindowCount() == 1 && (!this.getChildWindow(0).needsTitleWindow() || parentWindow.showsWindowTitle()) ? this.getChildWindow(0).getBestFittedWindow(parentWindow) : this;
    }

    @Override
    protected void write(ObjectOutputStream out, WriteContext context, ViewWriter viewWriter) throws IOException {
        out.writeInt(3);
        viewWriter.writeWindowItem(this.getWindowItem(), out, context);
        super.write(out, context, viewWriter);
    }
}

