/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.RestoreIcon;

public final class RestoreParentWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final RestoreParentWindowAction INSTANCE = new RestoreParentWindowAction();
    private static final Icon icon = new RestoreIcon(10);

    private RestoreParentWindowAction() {
    }

    @Override
    public String getName() {
        return "Restore";
    }

    @Override
    public boolean isPerformable(DockingWindow window) {
        if (window.isMinimized() && window.isRestorable()) {
            return true;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(window);
        return tabWindow != null && tabWindow.isMaximized() && tabWindow.isRestorable();
    }

    @Override
    public void perform(DockingWindow window) {
        if (window != null && window.isMinimized()) {
            RestoreParentWindowAction.restore(window);
        } else {
            TabWindow tabWindow = DockingUtil.getTabWindowFor(window);
            if (tabWindow != null && tabWindow.isMaximized()) {
                RestoreParentWindowAction.restore(tabWindow);
            }
        }
    }

    @Override
    public Icon getIcon() {
        return icon;
    }

    private static void restore(DockingWindow window) {
        if (window != null && window.isRestorable()) {
            window.restore();
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

