/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.theme.internal.laftheme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.beans.PropertyVetoException;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JInternalFrame;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import net.infonode.docking.View;
import net.infonode.docking.internal.ViewTitleBar;
import net.infonode.docking.theme.internal.laftheme.TitleBarUIListener;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.GradientComponentPainter;
import net.infonode.tabbedpanel.theme.internal.laftheme.SizeIcon;
import net.infonode.util.ColorUtil;
import net.infonode.util.Direction;

public class TitleBarUI {
    private static final int NUM_FADE_COLORS = 25;
    private static final int BUTTON_OFFSET = 2;
    private static final int RIGHT_INSET = 4;
    private final boolean showing = true;
    private boolean enabled;
    private final DynamicUIManagerListener uiListener = new DynamicUIManagerListener(){

        @Override
        public void lookAndFeelChanged() {
            TitleBarUI.this.doUpdate();
        }

        @Override
        public void propertiesChanging() {
            TitleBarUI.this.listener.updating();
        }

        @Override
        public void propertiesChanged() {
            TitleBarUI.this.doUpdate();
        }

        @Override
        public void lookAndFeelChanging() {
            TitleBarUI.this.listener.updating();
        }
    };
    private final Color[] fadeSelectedColors = new Color[25];
    private final Color[] fadeNormalColors = new Color[25];
    private final IFrame iFrame = new IFrame();
    private JFrame frame;
    private Dimension reportedMinimumSize;
    private Dimension minimumSize;
    private Insets iFrameInsets;
    private Color inactiveBackgroundColor;
    private Color activeBackgroundColor;
    private Color foundBackgroundColor;
    private boolean skipIFrame = false;
    private final ComponentPainter activeComponentPainter = new ComponentPainter(){

        @Override
        public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        }

        @Override
        public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
            g.translate(-x, -y);
            TitleBarUI.this.paintTitleBar(component, g, true, width, height, Direction.UP);
            g.translate(x, y);
        }

        @Override
        public boolean isOpaque(Component component) {
            return false;
        }

        @Override
        public Color getColor(Component component) {
            return TitleBarUI.this.getActiveBackgroundColor();
        }
    };
    private final ComponentPainter inactiveComponentPainter = new ComponentPainter(){

        @Override
        public void paint(Component component, Graphics g, int x, int y, int width, int height) {
        }

        @Override
        public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
            g.translate(-x, -y);
            TitleBarUI.this.paintTitleBar(component, g, false, width, height, Direction.UP);
            g.translate(x, y);
        }

        @Override
        public boolean isOpaque(Component component) {
            return false;
        }

        @Override
        public Color getColor(Component component) {
            return TitleBarUI.this.getInactiveBackgroundColor();
        }
    };
    private final TitleBarUIListener listener;

    public TitleBarUI(TitleBarUIListener listener, boolean enabled) {
        this.enabled = enabled;
        this.listener = listener;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void dispose() {
        DynamicUIManager.getInstance().removePrioritizedListener(this.uiListener);
        this.frame.removeAll();
        this.frame.dispose();
    }

    public void init() {
        DynamicUIManager.getInstance().addPrioritizedListener(this.uiListener);
        this.frame = new JFrame();
        this.frame.getContentPane().setLayout(null);
        this.frame.getContentPane().add(this.iFrame);
        this.frame.pack();
        this.listener.updating();
        this.update();
    }

    private void doUpdate() {
        this.setEnabled(false);
        SwingUtilities.updateComponentTreeUI(this.frame);
        this.update();
    }

    private void update() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TitleBarUI.this.iFrame.setClosable(false);
                TitleBarUI.this.iFrame.setMaximizable(false);
                TitleBarUI.this.iFrame.setIconifiable(false);
                TitleBarUI.this.iFrame.setBounds(0, 0, 50, 50);
                TitleBarUI.this.iFrame.setResizable(false);
                TitleBarUI.this.iFrame.setVisible(true);
                TitleBarUI.this.iFrame.setTitle(" ");
                TitleBarUI.this.iFrame.setFrameIcon(SizeIcon.EMPTY);
                TitleBarUI.this.iFrameInsets = (Insets)TitleBarUI.this.iFrame.getInsets().clone();
                if (UIManager.getLookAndFeel().getClass().getName().indexOf(".MotifLookAndFeel") != -1) {
                    ((TitleBarUI)TitleBarUI.this).iFrameInsets.left += 19;
                }
                TitleBarUI.this.reportedMinimumSize = TitleBarUI.this.iFrame.getPreferredSize();
                TitleBarUI.this.minimumSize = new Dimension(Math.max(0, ((TitleBarUI)TitleBarUI.this).reportedMinimumSize.width - ((TitleBarUI)TitleBarUI.this).iFrameInsets.left - ((TitleBarUI)TitleBarUI.this).iFrameInsets.right), ((TitleBarUI)TitleBarUI.this).reportedMinimumSize.height - ((TitleBarUI)TitleBarUI.this).iFrameInsets.top - ((TitleBarUI)TitleBarUI.this).iFrameInsets.bottom);
                String lafName = UIManager.getLookAndFeel().getClass().getName();
                TitleBarUI.this.skipIFrame = lafName.indexOf("GTKLookAndFeel") != -1 || (lafName.indexOf(".WindowsLookAndFeel") != -1 || UIManager.getLookAndFeel().getClass().getName().indexOf(".Office2003LookAndFeel") != -1) && Toolkit.getDefaultToolkit().getDesktopProperty("win.xpstyle.themeActive") != null;
                TitleBarUI.this.estimateBackgroundColors();
                TitleBarUI.this.setEnabled(true);
                TitleBarUI.this.listener.updated();
            }
        });
    }

    private void estimateBackgroundColors() {
        this.activeBackgroundColor = this.estimateBackgroundColor(true);
        this.inactiveBackgroundColor = this.estimateBackgroundColor(false);
        double factor = 255 / this.fadeSelectedColors.length;
        int i = 0;
        while (i < this.fadeSelectedColors.length) {
            if (this.activeBackgroundColor != null) {
                this.fadeSelectedColors[i] = new Color(this.activeBackgroundColor.getRed(), this.activeBackgroundColor.getGreen(), this.activeBackgroundColor.getBlue(), (int)((double)(i + 1) * factor));
            }
            if (this.inactiveBackgroundColor != null) {
                this.fadeNormalColors[i] = new Color(this.inactiveBackgroundColor.getRed(), this.inactiveBackgroundColor.getGreen(), this.inactiveBackgroundColor.getBlue(), (int)((double)(i + 1) * factor));
            }
            ++i;
        }
    }

    private Color estimateBackgroundColor(boolean selected) {
        this.setSize(400);
        this.iFrame.setSelectedActivated(selected);
        BufferedImage img = new BufferedImage(this.iFrame.getWidth(), this.iFrame.getHeight(), 2);
        int x = this.iFrame.getWidth() - this.iFrameInsets.right - 3;
        int y = this.iFrameInsets.top + 3;
        final int px = x;
        final int py = y;
        RGBImageFilter colorFilter = new RGBImageFilter(){

            @Override
            public int filterRGB(int x, int y, int rgb) {
                if (px == x && py == y) {
                    int r = rgb >> 16 & 0xFF;
                    int g = rgb >> 8 & 0xFF;
                    int b = rgb & 0xFF;
                    int a = rgb >> 24 & 0xFF;
                    TitleBarUI.this.foundBackgroundColor = new Color(r, g, b, a);
                }
                return rgb;
            }
        };
        FilteredImageSource source = new FilteredImageSource(img.getSource(), colorFilter);
        this.iFrame.paint(img.getGraphics());
        BufferedImage img2 = new BufferedImage(img.getWidth(), img.getHeight(), 2);
        img2.getGraphics().drawImage(Toolkit.getDefaultToolkit().createImage(source), 0, 0, null);
        return this.foundBackgroundColor;
    }

    public DimensionProvider getSizeDimensionProvider() {
        return this.skipIFrame ? null : new DimensionProvider(){

            @Override
            public Dimension getDimension(Component c) {
                return TitleBarUI.this.minimumSize;
            }
        };
    }

    public void paintTitleBar(Component c, Graphics g, boolean selected, int width, int height, Direction d) {
        if (this.enabled) {
            View view = this.findView(c);
            if (view == null) {
                return;
            }
            this.setTitleAndIcon(view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getTitle(), view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getIcon());
            this.iFrame.setSelectedActivated(selected);
            this.setSize(width);
            Shape clip = g.getClip();
            g.clipRect(0, 0, width, this.reportedMinimumSize.height - this.iFrameInsets.top - this.iFrameInsets.bottom);
            g.translate(-this.iFrameInsets.left, -this.iFrameInsets.top);
            this.iFrame.paint(g);
            g.translate(this.iFrameInsets.left, this.iFrameInsets.top);
            g.setClip(clip);
            this.paintSolidButtonBackground(c, g, selected);
        }
    }

    private void paintSolidButtonBackground(Component c, Graphics g, boolean selected) {
        ViewTitleBar bar = (ViewTitleBar)c;
        JComponent[] comps = bar.getRightTitleComponents();
        if (comps.length > 0) {
            int width = 0;
            int i = 0;
            while (i < comps.length) {
                if (comps[i].isVisible()) {
                    width += comps[i].getWidth();
                }
                ++i;
            }
            Color background = selected ? this.activeBackgroundColor : this.inactiveBackgroundColor;
            Color[] fadeColors = selected ? this.fadeSelectedColors : this.fadeNormalColors;
            int i2 = 0;
            while (i2 < fadeColors.length) {
                g.setColor(fadeColors[i2]);
                int xPos = c.getWidth() - width - (fadeColors.length - i2) - 4;
                g.drawLine(xPos, 2, xPos, c.getHeight() - 4);
                ++i2;
            }
            g.setColor(background);
            g.fillRect(c.getWidth() - width - 4, 2, width + 4, c.getHeight() - 4);
        }
    }

    private void setTitleAndIcon(String title, Icon icon) {
        this.iFrame.setTitle(title);
        this.iFrame.setFrameIcon(icon == null ? SizeIcon.EMPTY : icon);
    }

    private View findView(Component c) {
        if (c == null || c instanceof View) {
            return (View)c;
        }
        return this.findView(c.getParent());
    }

    private void setSize(int width) {
        this.iFrame.setSize(width + this.iFrameInsets.left + this.iFrameInsets.right, this.reportedMinimumSize.height);
        this.iFrame.invalidate();
        this.iFrame.validate();
    }

    public boolean isRenderingIcon() {
        return !this.skipIFrame;
    }

    public boolean isRenderingTitle() {
        return !this.skipIFrame;
    }

    public Direction getRenderingDirection() {
        return Direction.RIGHT;
    }

    public ComponentPainter getInactiveComponentPainter() {
        if (!this.skipIFrame) {
            return this.inactiveComponentPainter;
        }
        Color bkg = UIManager.getColor("InternalFrame.inactiveTitleBackground");
        if (bkg == null) {
            bkg = this.inactiveBackgroundColor;
        }
        return this.createComponentPainter(bkg, UIManager.getColor("InternalFrame.inactiveTitleGradient"));
    }

    public ComponentPainter getActiveComponentPainter() {
        if (!this.skipIFrame) {
            return this.activeComponentPainter;
        }
        Color bkg = UIManager.getColor("InternalFrame.activeTitleBackground");
        if (bkg == null) {
            bkg = this.activeBackgroundColor;
        }
        return this.createComponentPainter(bkg, UIManager.getColor("InternalFrame.activeTitleGradient"));
    }

    public Insets getInsets() {
        return this.skipIFrame ? new Insets(2, 2, 2, 2) : new Insets(0, 0, 0, 4);
    }

    public Color getInactiveBackgroundColor() {
        return this.inactiveBackgroundColor;
    }

    public Color getActiveBackgroundColor() {
        return this.activeBackgroundColor;
    }

    private ComponentPainter createComponentPainter(final Color background, final Color gradient) {
        final Color avgColor = ColorUtil.blend(background, gradient, 0.5);
        final ComponentPainter painter = this.createGradientSegmentPainter(background, gradient, true);
        return new ComponentPainter(){

            @Override
            public void paint(Component component, Graphics g, int x, int y, int width, int height) {
            }

            @Override
            public void paint(Component component, Graphics g, int x, int y, int width, int height, Direction direction, boolean horizontalFlip, boolean verticalFlip) {
                g.setColor(gradient);
                g.drawLine(x, y, x + width - 1, y);
                g.drawLine(x, y, x, y + height - 1);
                g.setColor(avgColor);
                g.drawRect(x + 1, y + 1, width - 3, height - 3);
                painter.paint(component, g, x + 2, y + 2, width - 4, height - 4, direction, horizontalFlip, verticalFlip);
                g.setColor(background);
                g.drawLine(x + 1, height - 1 + y, x + width - 1, height - 1 + y);
                g.drawLine(x + width - 1, y, x + width - 1, y + height - 1);
            }

            @Override
            public boolean isOpaque(Component component) {
                return painter.isOpaque(component);
            }

            @Override
            public Color getColor(Component component) {
                return painter.getColor(component);
            }
        };
    }

    private ComponentPainter createGradientSegmentPainter(Color background, Color gradient, boolean flip) {
        if (background != null) {
            gradient = gradient == null ? background : gradient;
            background = ColorUtil.mult(background, flip ? 1.05 : 0.9);
            gradient = ColorUtil.mult(gradient, flip ? 0.9 : 1.05);
            return new GradientComponentPainter(background, background, gradient, gradient);
        }
        return null;
    }

    private class IFrame
    extends JInternalFrame {
        @Override
        public void updateUI() {
            super.updateUI();
            this.setClosable(false);
            this.setIconifiable(false);
            this.setMaximizable(false);
            this.setFocusable(false);
        }

        public void setSelectedActivated(boolean selected) {
            try {
                this.setSelected(selected);
            }
            catch (PropertyVetoException e) {
                e.printStackTrace();
            }
        }

        @Override
        public boolean isShowing() {
            return true;
        }
    }
}

