/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.border;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import java.io.Serializable;
import javax.swing.border.Border;
import net.infonode.gui.ComponentUtil;
import net.infonode.gui.GraphicsUtil;
import net.infonode.util.ColorUtil;

public class EtchedLineBorder
implements Border,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean drawTop;
    private boolean drawBottom;
    private boolean drawLeft;
    private boolean drawRight;
    private Insets insets;
    private Color highlightColor;
    private Color shadowColor;

    public EtchedLineBorder() {
        this(true, true, true, true);
    }

    public EtchedLineBorder(boolean drawTop, boolean drawLeft, boolean drawBottom, boolean drawRight) {
        this(drawTop, drawLeft, drawBottom, drawRight, null, null);
    }

    public EtchedLineBorder(boolean drawTop, boolean drawLeft, boolean drawBottom, boolean drawRight, Color highlightColor, Color shadowColor) {
        this.drawBottom = drawBottom;
        this.drawLeft = drawLeft;
        this.drawRight = drawRight;
        this.drawTop = drawTop;
        this.insets = new Insets(drawTop ? 2 : 0, drawLeft ? 2 : 0, drawBottom ? 2 : 0, drawRight ? 2 : 0);
        this.highlightColor = highlightColor;
        this.shadowColor = shadowColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.insets;
    }

    @Override
    public boolean isBorderOpaque() {
        return false;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Color c1 = this.highlightColor == null ? ColorUtil.mult(ComponentUtil.getBackgroundColor(c), 1.7) : this.highlightColor;
        Color c2 = this.shadowColor == null ? ColorUtil.mult(ComponentUtil.getBackgroundColor(c), 0.5) : this.shadowColor;
        g.setColor(c1);
        if (this.drawTop) {
            GraphicsUtil.drawOptimizedLine(g, x, y + 1, x + width - 1, y + 1);
        }
        if (this.drawLeft) {
            GraphicsUtil.drawOptimizedLine(g, x + 1, y, x + 1, y + height - 1);
        }
        g.setColor(c2);
        if (this.drawBottom) {
            GraphicsUtil.drawOptimizedLine(g, x, y + height - 2, x + width - 1, y + height - 2);
        }
        if (this.drawRight) {
            GraphicsUtil.drawOptimizedLine(g, x + width - 2, y, x + width - 2, y + height - 1);
        }
        g.setColor(c1);
        if (this.drawBottom) {
            GraphicsUtil.drawOptimizedLine(g, x, y + height - 1, x + width - 1, y + height - 1);
        }
        if (this.drawRight) {
            GraphicsUtil.drawOptimizedLine(g, x + width - 1, y, x + width - 1, y + height - 1);
        }
        g.setColor(c2);
        if (this.drawTop) {
            GraphicsUtil.drawOptimizedLine(g, x, y, x + width - 1, y);
        }
        if (this.drawLeft) {
            GraphicsUtil.drawOptimizedLine(g, x, y, x, y + height - 1);
        }
        g.setColor(ComponentUtil.getBackgroundColor(c));
        if (this.drawTop && this.drawRight) {
            GraphicsUtil.drawOptimizedLine(g, x + width - 2, y + 1, x + width - 1, y);
        }
        if (this.drawBottom && this.drawLeft) {
            GraphicsUtil.drawOptimizedLine(g, x, y + height - 1, x + 1, y + height - 2);
        }
    }
}

