/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.gui.icon.button;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.UIManager;
import net.infonode.gui.ComponentUtil;
import net.infonode.util.ColorUtil;

public abstract class AbstractButtonIcon
implements Icon,
Serializable {
    private static final long serialVersionUID = 1L;
    private int size = 10;
    private Color defaultColor = null;
    private boolean shadowEnabled = true;
    private float shadowStrength = 0.3f;
    private boolean enabled = true;

    public AbstractButtonIcon() {
    }

    public AbstractButtonIcon(Color color) {
        this.defaultColor = color;
    }

    public AbstractButtonIcon(Color color, int size) {
        this(color);
        this.size = size;
    }

    public AbstractButtonIcon(int size) {
        this(size, true);
    }

    public AbstractButtonIcon(int size, boolean enabled) {
        this();
        this.size = size;
        this.enabled = enabled;
    }

    @Override
    public int getIconWidth() {
        return this.size;
    }

    @Override
    public int getIconHeight() {
        return this.size;
    }

    public boolean isShadowEnabled() {
        return this.shadowEnabled;
    }

    public void setShadowEnabled(boolean shadowEnabled) {
        this.shadowEnabled = shadowEnabled;
    }

    public float getShadowStrength() {
        return this.shadowStrength;
    }

    public void setShadowStrength(float shadowStrength) {
        this.shadowStrength = shadowStrength;
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Color color;
        Color oldColor = g.getColor();
        Color color2 = this.defaultColor == null ? (this.enabled ? c.getForeground() : UIManager.getColor("Button.disabledForeground")) : (color = this.defaultColor);
        if (color == null) {
            color = ColorUtil.blend(ComponentUtil.getBackgroundColor(c), c.getForeground(), 0.5);
        }
        if (this.shadowEnabled) {
            Color background = ComponentUtil.getBackgroundColor(c);
            g.setColor(ColorUtil.blend(background == null ? Color.BLACK : background, Color.BLACK, this.shadowStrength));
            this.paintIcon(c, g, x + 2, y + 2, x + this.size - 1, y + this.size - 1, true);
            g.setColor(color);
            this.paintIcon(c, g, x + 1, y + 1, x + this.size - 2, y + this.size - 2, false);
        } else {
            g.setColor(color);
            this.paintIcon(c, g, x, y, x + this.size - 1, y + this.size - 1, false);
        }
        g.setColor(oldColor);
    }

    protected void paintIcon(Component c, Graphics g, int x1, int y1, int x2, int y2, boolean isShadow) {
        this.paintIcon(c, g, x1, y1, x2, y2);
    }

    protected void paintIcon(Component c, Graphics g, int x1, int y1, int x2, int y2) {
    }
}

