/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.gui.util;

import javax.swing.AbstractButton;
import javax.swing.Icon;
import net.infonode.gui.button.ButtonFactory;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.ButtonFactoryProperty;
import net.infonode.properties.types.IconProperty;
import net.infonode.properties.types.StringProperty;

public class ButtonProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Button Properties", "");
    public static final IconProperty ICON = new IconProperty((PropertyGroup)PROPERTIES, "Icon", "Icon for the enabled button state.", PropertyMapValueHandler.INSTANCE);
    public static final IconProperty DISABLED_ICON = new IconProperty((PropertyGroup)PROPERTIES, "Disabled Icon", "Icon for the disabled button state.", PropertyMapValueHandler.INSTANCE);
    public static final StringProperty TOOL_TIP_TEXT = new StringProperty((PropertyGroup)PROPERTIES, "Tool Tip Text", "The button tool tip text.", PropertyMapValueHandler.INSTANCE);
    public static final ButtonFactoryProperty FACTORY = new ButtonFactoryProperty((PropertyGroup)PROPERTIES, "Factory", "The button factory. This factory is used to create a button. The created button will be assigned the icon from the '" + ICON.getName() + "' property or the '" + DISABLED_ICON.getName() + "' property and the tool tip from the '" + TOOL_TIP_TEXT.getName() + "' " + "property. An action listener is also added to the button.", PropertyMapValueHandler.INSTANCE);

    static {
        ButtonProperties properties = new ButtonProperties(PROPERTIES.getDefaultMap());
        properties.setIcon(null).setDisabledIcon(null).setToolTipText(null);
    }

    public ButtonProperties() {
        super(PROPERTIES);
    }

    public ButtonProperties(PropertyMap map) {
        super(map);
    }

    public ButtonProperties(ButtonProperties inheritFrom) {
        super(PropertyMapFactory.create(inheritFrom.getMap()));
    }

    public ButtonProperties addSuperObject(ButtonProperties properties) {
        this.getMap().addSuperMap(properties.getMap());
        return this;
    }

    public ButtonProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public ButtonProperties removeSuperObject(ButtonProperties superObject) {
        this.getMap().removeSuperMap(superObject.getMap());
        return this;
    }

    public ButtonProperties setIcon(Icon icon) {
        ICON.set(this.getMap(), icon);
        return this;
    }

    public Icon getIcon() {
        return ICON.get(this.getMap());
    }

    public ButtonProperties setDisabledIcon(Icon icon) {
        DISABLED_ICON.set(this.getMap(), icon);
        return this;
    }

    public Icon getDisabledIcon() {
        return DISABLED_ICON.get(this.getMap());
    }

    public String getToolTipText() {
        return TOOL_TIP_TEXT.get(this.getMap());
    }

    public ButtonProperties setToolTipText(String text) {
        TOOL_TIP_TEXT.set(this.getMap(), text);
        return this;
    }

    public ButtonFactory getFactory() {
        return FACTORY.get(this.getMap());
    }

    public ButtonProperties setFactory(ButtonFactory factory) {
        FACTORY.set(this.getMap(), factory);
        return this;
    }

    public AbstractButton applyTo(AbstractButton button) {
        button.setIcon(this.getIcon());
        button.setDisabledIcon(this.getDisabledIcon());
        button.setToolTipText(this.getToolTipText());
        return button;
    }
}

