/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.properties.types;

import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.util.PropertyValueHandler;
import net.infonode.properties.util.ValueHandlerProperty;

public class NumberProperty
extends ValueHandlerProperty {
    private long minValue;
    private long maxValue;
    private int preferredDigitCount;

    public NumberProperty(PropertyGroup group, String name, Class cl, String description, long minValue, long maxValue, int preferredDigitCount, PropertyValueHandler valueHandler) {
        super(group, name, cl, description, valueHandler);
        this.minValue = minValue;
        this.maxValue = maxValue;
        this.preferredDigitCount = preferredDigitCount;
    }

    public int getPreferredDigitCount() {
        return this.preferredDigitCount;
    }

    public long getMinValue() {
        return this.minValue;
    }

    public long getMaxValue() {
        return this.maxValue;
    }

    public long getLongValue(Object valueContainer) {
        Object value = this.getValue(valueContainer);
        return value == null ? Math.max(0L, this.minValue) : ((Number)this.getValue(valueContainer)).longValue();
    }

    @Override
    public boolean canBeAssiged(Object value) {
        if (!super.canBeAssiged(value)) {
            return false;
        }
        long v = ((Number)value).longValue();
        return this.minValue <= v && this.maxValue >= v;
    }
}

